package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CapitalVerifyRuleItemConfig;
import com.xforceplus.financialsettlement.service.ICapitalVerifyRuleItemConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-29
 */
@RestController
public class CapitalVerifyRuleItemConfigController {

  @Autowired
  private ICapitalVerifyRuleItemConfigService capitalVerifyRuleItemConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param capitalVerifyRuleItemConfig ${table.comment}
   * @return
   */
  @GetMapping("/capitalverifyruleitemconfigs" )
  public XfR getCapitalVerifyRuleItemConfigs(XfPage page, CapitalVerifyRuleItemConfig capitalVerifyRuleItemConfig) {
    return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.page(page, Wrappers.query(capitalVerifyRuleItemConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/capitalverifyruleitemconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param capitalVerifyRuleItemConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/capitalverifyruleitemconfigs")
  public XfR save(@RequestBody CapitalVerifyRuleItemConfig capitalVerifyRuleItemConfig) {
     return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.save(capitalVerifyRuleItemConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param capitalVerifyRuleItemConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/capitalverifyruleitemconfigs/{id}")
  public XfR putUpdate(@RequestBody CapitalVerifyRuleItemConfig capitalVerifyRuleItemConfig,@PathVariable Long id) {
      capitalVerifyRuleItemConfig.setId(id);
      return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.updateById(capitalVerifyRuleItemConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param capitalVerifyRuleItemConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/capitalverifyruleitemconfigs/{id}")
  public XfR patchUpdate(@RequestBody CapitalVerifyRuleItemConfig capitalVerifyRuleItemConfig,@PathVariable Long id) {
      CapitalVerifyRuleItemConfig upcapitalVerifyRuleItemConfig = capitalVerifyRuleItemConfigServiceImpl.getById(id);
      if(upcapitalVerifyRuleItemConfig != null){
        upcapitalVerifyRuleItemConfig = ObjectCopyUtils.copyProperties(capitalVerifyRuleItemConfig,upcapitalVerifyRuleItemConfig,true);
      }
      return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.updateById(upcapitalVerifyRuleItemConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/capitalverifyruleitemconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.removeById(id));
  }

  @PostMapping("/capitalverifyruleitemconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "capital_verify_rule_item_config");
     params.put("request", condition);

     return XfR.ok(capitalVerifyRuleItemConfigServiceImpl.querys(params));
  }

}
