package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialLaborUnionBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialLaborUnionBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-29
 */
@RestController
public class FinancialLaborUnionBillDetailController {

  @Autowired
  private IFinancialLaborUnionBillDetailService financialLaborUnionBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialLaborUnionBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financiallaborunionbilldetails" )
  public XfR getFinancialLaborUnionBillDetails(XfPage page, FinancialLaborUnionBillDetail financialLaborUnionBillDetail) {
    return XfR.ok(financialLaborUnionBillDetailServiceImpl.page(page, Wrappers.query(financialLaborUnionBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financiallaborunionbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialLaborUnionBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialLaborUnionBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financiallaborunionbilldetails")
  public XfR save(@RequestBody FinancialLaborUnionBillDetail financialLaborUnionBillDetail) {
     return XfR.ok(financialLaborUnionBillDetailServiceImpl.save(financialLaborUnionBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialLaborUnionBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financiallaborunionbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialLaborUnionBillDetail financialLaborUnionBillDetail,@PathVariable Long id) {
      financialLaborUnionBillDetail.setId(id);
      return XfR.ok(financialLaborUnionBillDetailServiceImpl.updateById(financialLaborUnionBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialLaborUnionBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financiallaborunionbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialLaborUnionBillDetail financialLaborUnionBillDetail,@PathVariable Long id) {
      FinancialLaborUnionBillDetail upfinancialLaborUnionBillDetail = financialLaborUnionBillDetailServiceImpl.getById(id);
      if(upfinancialLaborUnionBillDetail != null){
        upfinancialLaborUnionBillDetail = ObjectCopyUtils.copyProperties(financialLaborUnionBillDetail,upfinancialLaborUnionBillDetail,true);
      }
      return XfR.ok(financialLaborUnionBillDetailServiceImpl.updateById(upfinancialLaborUnionBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financiallaborunionbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialLaborUnionBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financiallaborunionbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_labor_union_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialLaborUnionBillDetailServiceImpl.querys(params));
  }

}
