package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPedestrianNumber;
import com.xforceplus.financialsettlement.service.IFinancialPedestrianNumberService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-29
 */
@RestController
public class FinancialPedestrianNumberController {

  @Autowired
  private IFinancialPedestrianNumberService financialPedestrianNumberServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPedestrianNumber ${table.comment}
   * @return
   */
  @GetMapping("/financialpedestriannumbers" )
  public XfR getFinancialPedestrianNumbers(XfPage page, FinancialPedestrianNumber financialPedestrianNumber) {
    return XfR.ok(financialPedestrianNumberServiceImpl.page(page, Wrappers.query(financialPedestrianNumber)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpedestriannumbers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPedestrianNumberServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPedestrianNumber ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpedestriannumbers")
  public XfR save(@RequestBody FinancialPedestrianNumber financialPedestrianNumber) {
     return XfR.ok(financialPedestrianNumberServiceImpl.save(financialPedestrianNumber));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPedestrianNumber ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpedestriannumbers/{id}")
  public XfR putUpdate(@RequestBody FinancialPedestrianNumber financialPedestrianNumber,@PathVariable Long id) {
      financialPedestrianNumber.setId(id);
      return XfR.ok(financialPedestrianNumberServiceImpl.updateById(financialPedestrianNumber));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPedestrianNumber ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpedestriannumbers/{id}")
  public XfR patchUpdate(@RequestBody FinancialPedestrianNumber financialPedestrianNumber,@PathVariable Long id) {
      FinancialPedestrianNumber upfinancialPedestrianNumber = financialPedestrianNumberServiceImpl.getById(id);
      if(upfinancialPedestrianNumber != null){
        upfinancialPedestrianNumber = ObjectCopyUtils.copyProperties(financialPedestrianNumber,upfinancialPedestrianNumber,true);
      }
      return XfR.ok(financialPedestrianNumberServiceImpl.updateById(upfinancialPedestrianNumber));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpedestriannumbers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPedestrianNumberServiceImpl.removeById(id));
  }

  @PostMapping("/financialpedestriannumbers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_pedestrian_number");
     params.put("request", condition);

     return XfR.ok(financialPedestrianNumberServiceImpl.querys(params));
  }

}
