package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TaxNoProductBind;
import com.xforceplus.financialsettlement.service.ITaxNoProductBindService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-29
 */
@RestController
public class TaxNoProductBindController {

  @Autowired
  private ITaxNoProductBindService taxNoProductBindServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxNoProductBind ${table.comment}
   * @return
   */
  @GetMapping("/taxnoproductbinds" )
  public XfR getTaxNoProductBinds(XfPage page, TaxNoProductBind taxNoProductBind) {
    return XfR.ok(taxNoProductBindServiceImpl.page(page, Wrappers.query(taxNoProductBind)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxnoproductbinds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxNoProductBindServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxNoProductBind ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxnoproductbinds")
  public XfR save(@RequestBody TaxNoProductBind taxNoProductBind) {
     return XfR.ok(taxNoProductBindServiceImpl.save(taxNoProductBind));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxNoProductBind ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxnoproductbinds/{id}")
  public XfR putUpdate(@RequestBody TaxNoProductBind taxNoProductBind,@PathVariable Long id) {
      taxNoProductBind.setId(id);
      return XfR.ok(taxNoProductBindServiceImpl.updateById(taxNoProductBind));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxNoProductBind ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxnoproductbinds/{id}")
  public XfR patchUpdate(@RequestBody TaxNoProductBind taxNoProductBind,@PathVariable Long id) {
      TaxNoProductBind uptaxNoProductBind = taxNoProductBindServiceImpl.getById(id);
      if(uptaxNoProductBind != null){
        uptaxNoProductBind = ObjectCopyUtils.copyProperties(taxNoProductBind,uptaxNoProductBind,true);
      }
      return XfR.ok(taxNoProductBindServiceImpl.updateById(uptaxNoProductBind));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxnoproductbinds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxNoProductBindServiceImpl.removeById(id));
  }

  @PostMapping("/taxnoproductbinds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_no_product_bind");
     params.put("request", condition);

     return XfR.ok(taxNoProductBindServiceImpl.querys(params));
  }

}
