package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.AllocationByInvoice;
import com.xforceplus.financialsettlement.service.IAllocationByInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 废弃前端控制器
 *
 * @author ultraman
 * @date 2022-11-14
 */
@RestController
public class AllocationByInvoiceController {

  @Autowired
  private IAllocationByInvoiceService allocationByInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allocationByInvoice 废弃
   * @return
   */
  @GetMapping("/allocationbyinvoices" )
  public XfR getAllocationByInvoices(XfPage page, AllocationByInvoice allocationByInvoice) {
    return XfR.ok(allocationByInvoiceServiceImpl.page(page, Wrappers.query(allocationByInvoice)));
  }

  /**
   * 通过id查询废弃
   * @param  id
   * @return XfR
   */
  @GetMapping("/allocationbyinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allocationByInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增废弃
   * @param allocationByInvoice 废弃
   * @return XfR
   */
  @PostMapping("/allocationbyinvoices")
  public XfR save(@RequestBody AllocationByInvoice allocationByInvoice) {
     return XfR.ok(allocationByInvoiceServiceImpl.save(allocationByInvoice));
  }

  /**
   * 修改-传入修改后的全部数据废弃
   * @param allocationByInvoice 废弃
   * @return XfR
   */
  @PutMapping("/allocationbyinvoices/{id}")
  public XfR putUpdate(@RequestBody AllocationByInvoice allocationByInvoice,@PathVariable Long id) {
      allocationByInvoice.setId(id);
      return XfR.ok(allocationByInvoiceServiceImpl.updateById(allocationByInvoice));
  }

  /**
   * 修改-传入修改的数据废弃
   * @param allocationByInvoice 废弃
   * @return XfR
   */
  @PatchMapping("/allocationbyinvoices/{id}")
  public XfR patchUpdate(@RequestBody AllocationByInvoice allocationByInvoice,@PathVariable Long id) {
      AllocationByInvoice upallocationByInvoice = allocationByInvoiceServiceImpl.getById(id);
      if(upallocationByInvoice != null){
        upallocationByInvoice = ObjectCopyUtils.copyProperties(allocationByInvoice,upallocationByInvoice,true);
      }
      return XfR.ok(allocationByInvoiceServiceImpl.updateById(upallocationByInvoice));
  }

  /**
   * 通过id删除废弃
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allocationbyinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allocationByInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/allocationbyinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allocation_by_invoice");
     params.put("request", condition);

     return XfR.ok(allocationByInvoiceServiceImpl.querys(params));
  }

}
