package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CapitalVerifyRuleConfig;
import com.xforceplus.financialsettlement.service.ICapitalVerifyRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-14
 */
@RestController
public class CapitalVerifyRuleConfigController {

  @Autowired
  private ICapitalVerifyRuleConfigService capitalVerifyRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param capitalVerifyRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/capitalverifyruleconfigs" )
  public XfR getCapitalVerifyRuleConfigs(XfPage page, CapitalVerifyRuleConfig capitalVerifyRuleConfig) {
    return XfR.ok(capitalVerifyRuleConfigServiceImpl.page(page, Wrappers.query(capitalVerifyRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/capitalverifyruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param capitalVerifyRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/capitalverifyruleconfigs")
  public XfR save(@RequestBody CapitalVerifyRuleConfig capitalVerifyRuleConfig) {
     return XfR.ok(capitalVerifyRuleConfigServiceImpl.save(capitalVerifyRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param capitalVerifyRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/capitalverifyruleconfigs/{id}")
  public XfR putUpdate(@RequestBody CapitalVerifyRuleConfig capitalVerifyRuleConfig,@PathVariable Long id) {
      capitalVerifyRuleConfig.setId(id);
      return XfR.ok(capitalVerifyRuleConfigServiceImpl.updateById(capitalVerifyRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param capitalVerifyRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/capitalverifyruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody CapitalVerifyRuleConfig capitalVerifyRuleConfig,@PathVariable Long id) {
      CapitalVerifyRuleConfig upcapitalVerifyRuleConfig = capitalVerifyRuleConfigServiceImpl.getById(id);
      if(upcapitalVerifyRuleConfig != null){
        upcapitalVerifyRuleConfig = ObjectCopyUtils.copyProperties(capitalVerifyRuleConfig,upcapitalVerifyRuleConfig,true);
      }
      return XfR.ok(capitalVerifyRuleConfigServiceImpl.updateById(upcapitalVerifyRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/capitalverifyruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/capitalverifyruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "capital_verify_rule_config");
     params.put("request", condition);

     return XfR.ok(capitalVerifyRuleConfigServiceImpl.querys(params));
  }

}
