package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeRelation;
import com.xforceplus.financialsettlement.service.IChargeCodeRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-14
 */
@RestController
public class ChargeCodeRelationController {

  @Autowired
  private IChargeCodeRelationService chargeCodeRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeRelation ${table.comment}
   * @return
   */
  @GetMapping("/chargecoderelations" )
  public XfR getChargeCodeRelations(XfPage page, ChargeCodeRelation chargeCodeRelation) {
    return XfR.ok(chargeCodeRelationServiceImpl.page(page, Wrappers.query(chargeCodeRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecoderelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecoderelations")
  public XfR save(@RequestBody ChargeCodeRelation chargeCodeRelation) {
     return XfR.ok(chargeCodeRelationServiceImpl.save(chargeCodeRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecoderelations/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeRelation chargeCodeRelation,@PathVariable Long id) {
      chargeCodeRelation.setId(id);
      return XfR.ok(chargeCodeRelationServiceImpl.updateById(chargeCodeRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecoderelations/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeRelation chargeCodeRelation,@PathVariable Long id) {
      ChargeCodeRelation upchargeCodeRelation = chargeCodeRelationServiceImpl.getById(id);
      if(upchargeCodeRelation != null){
        upchargeCodeRelation = ObjectCopyUtils.copyProperties(chargeCodeRelation,upchargeCodeRelation,true);
      }
      return XfR.ok(chargeCodeRelationServiceImpl.updateById(upchargeCodeRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecoderelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeRelationServiceImpl.removeById(id));
  }

  @PostMapping("/chargecoderelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_relation");
     params.put("request", condition);

     return XfR.ok(chargeCodeRelationServiceImpl.querys(params));
  }

}
