package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialInvoicePledgeBill;
import com.xforceplus.financialsettlement.service.IFinancialInvoicePledgeBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-14
 */
@RestController
public class FinancialInvoicePledgeBillController {

  @Autowired
  private IFinancialInvoicePledgeBillService financialInvoicePledgeBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialInvoicePledgeBill ${table.comment}
   * @return
   */
  @GetMapping("/financialinvoicepledgebills" )
  public XfR getFinancialInvoicePledgeBills(XfPage page, FinancialInvoicePledgeBill financialInvoicePledgeBill) {
    return XfR.ok(financialInvoicePledgeBillServiceImpl.page(page, Wrappers.query(financialInvoicePledgeBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialinvoicepledgebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialInvoicePledgeBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialInvoicePledgeBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialinvoicepledgebills")
  public XfR save(@RequestBody FinancialInvoicePledgeBill financialInvoicePledgeBill) {
     return XfR.ok(financialInvoicePledgeBillServiceImpl.save(financialInvoicePledgeBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialInvoicePledgeBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialinvoicepledgebills/{id}")
  public XfR putUpdate(@RequestBody FinancialInvoicePledgeBill financialInvoicePledgeBill,@PathVariable Long id) {
      financialInvoicePledgeBill.setId(id);
      return XfR.ok(financialInvoicePledgeBillServiceImpl.updateById(financialInvoicePledgeBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialInvoicePledgeBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialinvoicepledgebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialInvoicePledgeBill financialInvoicePledgeBill,@PathVariable Long id) {
      FinancialInvoicePledgeBill upfinancialInvoicePledgeBill = financialInvoicePledgeBillServiceImpl.getById(id);
      if(upfinancialInvoicePledgeBill != null){
        upfinancialInvoicePledgeBill = ObjectCopyUtils.copyProperties(financialInvoicePledgeBill,upfinancialInvoicePledgeBill,true);
      }
      return XfR.ok(financialInvoicePledgeBillServiceImpl.updateById(upfinancialInvoicePledgeBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialinvoicepledgebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialInvoicePledgeBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialinvoicepledgebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_invoice_pledge_bill");
     params.put("request", condition);

     return XfR.ok(financialInvoicePledgeBillServiceImpl.querys(params));
  }

}
