package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.BillStaticsDetail;
import com.xforceplus.financialsettlement.service.IBillStaticsDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-22
 */
@RestController
public class BillStaticsDetailController {

  @Autowired
  private IBillStaticsDetailService billStaticsDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billStaticsDetail ${table.comment}
   * @return
   */
  @GetMapping("/billstaticsdetails" )
  public XfR getBillStaticsDetails(XfPage page, BillStaticsDetail billStaticsDetail) {
    return XfR.ok(billStaticsDetailServiceImpl.page(page, Wrappers.query(billStaticsDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billstaticsdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billStaticsDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billStaticsDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/billstaticsdetails")
  public XfR save(@RequestBody BillStaticsDetail billStaticsDetail) {
     return XfR.ok(billStaticsDetailServiceImpl.save(billStaticsDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billStaticsDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/billstaticsdetails/{id}")
  public XfR putUpdate(@RequestBody BillStaticsDetail billStaticsDetail,@PathVariable Long id) {
      billStaticsDetail.setId(id);
      return XfR.ok(billStaticsDetailServiceImpl.updateById(billStaticsDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billStaticsDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billstaticsdetails/{id}")
  public XfR patchUpdate(@RequestBody BillStaticsDetail billStaticsDetail,@PathVariable Long id) {
      BillStaticsDetail upbillStaticsDetail = billStaticsDetailServiceImpl.getById(id);
      if(upbillStaticsDetail != null){
        upbillStaticsDetail = ObjectCopyUtils.copyProperties(billStaticsDetail,upbillStaticsDetail,true);
      }
      return XfR.ok(billStaticsDetailServiceImpl.updateById(upbillStaticsDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billstaticsdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billStaticsDetailServiceImpl.removeById(id));
  }

  @PostMapping("/billstaticsdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_statics_detail");
     params.put("request", condition);

     return XfR.ok(billStaticsDetailServiceImpl.querys(params));
  }

}
