package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.CompensateData;
import com.xforceplus.financialsettlement.service.ICompensateDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-22
 */
@RestController
public class CompensateDataController {

  @Autowired
  private ICompensateDataService compensateDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compensateData ${table.comment}
   * @return
   */
  @GetMapping("/compensatedatas" )
  public XfR getCompensateDatas(XfPage page, CompensateData compensateData) {
    return XfR.ok(compensateDataServiceImpl.page(page, Wrappers.query(compensateData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compensatedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compensateDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compensateData ${table.comment}
   * @return XfR
   */
  @PostMapping("/compensatedatas")
  public XfR save(@RequestBody CompensateData compensateData) {
     return XfR.ok(compensateDataServiceImpl.save(compensateData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compensateData ${table.comment}
   * @return XfR
   */
  @PutMapping("/compensatedatas/{id}")
  public XfR putUpdate(@RequestBody CompensateData compensateData,@PathVariable Long id) {
      compensateData.setId(id);
      return XfR.ok(compensateDataServiceImpl.updateById(compensateData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compensateData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compensatedatas/{id}")
  public XfR patchUpdate(@RequestBody CompensateData compensateData,@PathVariable Long id) {
      CompensateData upcompensateData = compensateDataServiceImpl.getById(id);
      if(upcompensateData != null){
        upcompensateData = ObjectCopyUtils.copyProperties(compensateData,upcompensateData,true);
      }
      return XfR.ok(compensateDataServiceImpl.updateById(upcompensateData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compensatedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compensateDataServiceImpl.removeById(id));
  }

  @PostMapping("/compensatedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compensate_data");
     params.put("request", condition);

     return XfR.ok(compensateDataServiceImpl.querys(params));
  }

}
