package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialRefundBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialRefundBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 退款申请单明细前端控制器
 *
 * @author ultraman
 * @date 2022-11-22
 */
@RestController
public class FinancialRefundBillDetailController {

  @Autowired
  private IFinancialRefundBillDetailService financialRefundBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialRefundBillDetail 退款申请单明细
   * @return
   */
  @GetMapping("/financialrefundbilldetails" )
  public XfR getFinancialRefundBillDetails(XfPage page, FinancialRefundBillDetail financialRefundBillDetail) {
    return XfR.ok(financialRefundBillDetailServiceImpl.page(page, Wrappers.query(financialRefundBillDetail)));
  }

  /**
   * 通过id查询退款申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialrefundbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialRefundBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增退款申请单明细
   * @param financialRefundBillDetail 退款申请单明细
   * @return XfR
   */
  @PostMapping("/financialrefundbilldetails")
  public XfR save(@RequestBody FinancialRefundBillDetail financialRefundBillDetail) {
     return XfR.ok(financialRefundBillDetailServiceImpl.save(financialRefundBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据退款申请单明细
   * @param financialRefundBillDetail 退款申请单明细
   * @return XfR
   */
  @PutMapping("/financialrefundbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialRefundBillDetail financialRefundBillDetail,@PathVariable Long id) {
      financialRefundBillDetail.setId(id);
      return XfR.ok(financialRefundBillDetailServiceImpl.updateById(financialRefundBillDetail));
  }

  /**
   * 修改-传入修改的数据退款申请单明细
   * @param financialRefundBillDetail 退款申请单明细
   * @return XfR
   */
  @PatchMapping("/financialrefundbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialRefundBillDetail financialRefundBillDetail,@PathVariable Long id) {
      FinancialRefundBillDetail upfinancialRefundBillDetail = financialRefundBillDetailServiceImpl.getById(id);
      if(upfinancialRefundBillDetail != null){
        upfinancialRefundBillDetail = ObjectCopyUtils.copyProperties(financialRefundBillDetail,upfinancialRefundBillDetail,true);
      }
      return XfR.ok(financialRefundBillDetailServiceImpl.updateById(upfinancialRefundBillDetail));
  }

  /**
   * 通过id删除退款申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialrefundbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialRefundBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialrefundbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_refund_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialRefundBillDetailServiceImpl.querys(params));
  }

}
