package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPersonLoanBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialPersonLoanBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 个人借款申请单明细前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class FinancialPersonLoanBillDetailController {

  @Autowired
  private IFinancialPersonLoanBillDetailService financialPersonLoanBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return
   */
  @GetMapping("/financialpersonloanbilldetails" )
  public XfR getFinancialPersonLoanBillDetails(XfPage page, FinancialPersonLoanBillDetail financialPersonLoanBillDetail) {
    return XfR.ok(financialPersonLoanBillDetailServiceImpl.page(page, Wrappers.query(financialPersonLoanBillDetail)));
  }

  /**
   * 通过id查询个人借款申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpersonloanbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增个人借款申请单明细
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return XfR
   */
  @PostMapping("/financialpersonloanbilldetails")
  public XfR save(@RequestBody FinancialPersonLoanBillDetail financialPersonLoanBillDetail) {
     return XfR.ok(financialPersonLoanBillDetailServiceImpl.save(financialPersonLoanBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据个人借款申请单明细
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return XfR
   */
  @PutMapping("/financialpersonloanbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialPersonLoanBillDetail financialPersonLoanBillDetail,@PathVariable Long id) {
      financialPersonLoanBillDetail.setId(id);
      return XfR.ok(financialPersonLoanBillDetailServiceImpl.updateById(financialPersonLoanBillDetail));
  }

  /**
   * 修改-传入修改的数据个人借款申请单明细
   * @param financialPersonLoanBillDetail 个人借款申请单明细
   * @return XfR
   */
  @PatchMapping("/financialpersonloanbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialPersonLoanBillDetail financialPersonLoanBillDetail,@PathVariable Long id) {
      FinancialPersonLoanBillDetail upfinancialPersonLoanBillDetail = financialPersonLoanBillDetailServiceImpl.getById(id);
      if(upfinancialPersonLoanBillDetail != null){
        upfinancialPersonLoanBillDetail = ObjectCopyUtils.copyProperties(financialPersonLoanBillDetail,upfinancialPersonLoanBillDetail,true);
      }
      return XfR.ok(financialPersonLoanBillDetailServiceImpl.updateById(upfinancialPersonLoanBillDetail));
  }

  /**
   * 通过id删除个人借款申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpersonloanbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialpersonloanbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_person_loan_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialPersonLoanBillDetailServiceImpl.querys(params));
  }

}
