package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.BillSyn;
import com.xforceplus.financialsettlement.service.IBillSynService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 *  单据同步对象-易快报前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class BillSynController {

  @Autowired
  private IBillSynService billSynServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billSyn  单据同步对象-易快报
   * @return
   */
  @GetMapping("/billsyns" )
  public XfR getBillSyns(XfPage page, BillSyn billSyn) {
    return XfR.ok(billSynServiceImpl.page(page, Wrappers.query(billSyn)));
  }

  /**
   * 通过id查询 单据同步对象-易快报
   * @param  id
   * @return XfR
   */
  @GetMapping("/billsyns/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billSynServiceImpl.getById(id));
  }

  /**
   * 新增 单据同步对象-易快报
   * @param billSyn  单据同步对象-易快报
   * @return XfR
   */
  @PostMapping("/billsyns")
  public XfR save(@RequestBody BillSyn billSyn) {
     return XfR.ok(billSynServiceImpl.save(billSyn));
  }

  /**
   * 修改-传入修改后的全部数据 单据同步对象-易快报
   * @param billSyn  单据同步对象-易快报
   * @return XfR
   */
  @PutMapping("/billsyns/{id}")
  public XfR putUpdate(@RequestBody BillSyn billSyn,@PathVariable Long id) {
      billSyn.setId(id);
      return XfR.ok(billSynServiceImpl.updateById(billSyn));
  }

  /**
   * 修改-传入修改的数据 单据同步对象-易快报
   * @param billSyn  单据同步对象-易快报
   * @return XfR
   */
  @PatchMapping("/billsyns/{id}")
  public XfR patchUpdate(@RequestBody BillSyn billSyn,@PathVariable Long id) {
      BillSyn upbillSyn = billSynServiceImpl.getById(id);
      if(upbillSyn != null){
        upbillSyn = ObjectCopyUtils.copyProperties(billSyn,upbillSyn,true);
      }
      return XfR.ok(billSynServiceImpl.updateById(upbillSyn));
  }

  /**
   * 通过id删除 单据同步对象-易快报
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billsyns/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billSynServiceImpl.removeById(id));
  }

  @PostMapping("/billsyns/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_syn");
     params.put("request", condition);

     return XfR.ok(billSynServiceImpl.querys(params));
  }

}
