package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialCostTypeAdjustBill;
import com.xforceplus.financialsettlement.service.IFinancialCostTypeAdjustBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class FinancialCostTypeAdjustBillController {

  @Autowired
  private IFinancialCostTypeAdjustBillService financialCostTypeAdjustBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialCostTypeAdjustBill ${table.comment}
   * @return
   */
  @GetMapping("/financialcosttypeadjustbills" )
  public XfR getFinancialCostTypeAdjustBills(XfPage page, FinancialCostTypeAdjustBill financialCostTypeAdjustBill) {
    return XfR.ok(financialCostTypeAdjustBillServiceImpl.page(page, Wrappers.query(financialCostTypeAdjustBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialcosttypeadjustbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialCostTypeAdjustBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialCostTypeAdjustBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialcosttypeadjustbills")
  public XfR save(@RequestBody FinancialCostTypeAdjustBill financialCostTypeAdjustBill) {
     return XfR.ok(financialCostTypeAdjustBillServiceImpl.save(financialCostTypeAdjustBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialCostTypeAdjustBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialcosttypeadjustbills/{id}")
  public XfR putUpdate(@RequestBody FinancialCostTypeAdjustBill financialCostTypeAdjustBill,@PathVariable Long id) {
      financialCostTypeAdjustBill.setId(id);
      return XfR.ok(financialCostTypeAdjustBillServiceImpl.updateById(financialCostTypeAdjustBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialCostTypeAdjustBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialcosttypeadjustbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialCostTypeAdjustBill financialCostTypeAdjustBill,@PathVariable Long id) {
      FinancialCostTypeAdjustBill upfinancialCostTypeAdjustBill = financialCostTypeAdjustBillServiceImpl.getById(id);
      if(upfinancialCostTypeAdjustBill != null){
        upfinancialCostTypeAdjustBill = ObjectCopyUtils.copyProperties(financialCostTypeAdjustBill,upfinancialCostTypeAdjustBill,true);
      }
      return XfR.ok(financialCostTypeAdjustBillServiceImpl.updateById(upfinancialCostTypeAdjustBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialcosttypeadjustbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialCostTypeAdjustBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialcosttypeadjustbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_cost_type_adjust_bill");
     params.put("request", condition);

     return XfR.ok(financialCostTypeAdjustBillServiceImpl.querys(params));
  }

}
