package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPersonLoanBill;
import com.xforceplus.financialsettlement.service.IFinancialPersonLoanBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 个人借款申请单前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class FinancialPersonLoanBillController {

  @Autowired
  private IFinancialPersonLoanBillService financialPersonLoanBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPersonLoanBill 个人借款申请单
   * @return
   */
  @GetMapping("/financialpersonloanbills" )
  public XfR getFinancialPersonLoanBills(XfPage page, FinancialPersonLoanBill financialPersonLoanBill) {
    return XfR.ok(financialPersonLoanBillServiceImpl.page(page, Wrappers.query(financialPersonLoanBill)));
  }

  /**
   * 通过id查询个人借款申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpersonloanbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBillServiceImpl.getById(id));
  }

  /**
   * 新增个人借款申请单
   * @param financialPersonLoanBill 个人借款申请单
   * @return XfR
   */
  @PostMapping("/financialpersonloanbills")
  public XfR save(@RequestBody FinancialPersonLoanBill financialPersonLoanBill) {
     return XfR.ok(financialPersonLoanBillServiceImpl.save(financialPersonLoanBill));
  }

  /**
   * 修改-传入修改后的全部数据个人借款申请单
   * @param financialPersonLoanBill 个人借款申请单
   * @return XfR
   */
  @PutMapping("/financialpersonloanbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPersonLoanBill financialPersonLoanBill,@PathVariable Long id) {
      financialPersonLoanBill.setId(id);
      return XfR.ok(financialPersonLoanBillServiceImpl.updateById(financialPersonLoanBill));
  }

  /**
   * 修改-传入修改的数据个人借款申请单
   * @param financialPersonLoanBill 个人借款申请单
   * @return XfR
   */
  @PatchMapping("/financialpersonloanbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPersonLoanBill financialPersonLoanBill,@PathVariable Long id) {
      FinancialPersonLoanBill upfinancialPersonLoanBill = financialPersonLoanBillServiceImpl.getById(id);
      if(upfinancialPersonLoanBill != null){
        upfinancialPersonLoanBill = ObjectCopyUtils.copyProperties(financialPersonLoanBill,upfinancialPersonLoanBill,true);
      }
      return XfR.ok(financialPersonLoanBillServiceImpl.updateById(upfinancialPersonLoanBill));
  }

  /**
   * 通过id删除个人借款申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpersonloanbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPersonLoanBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpersonloanbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_person_loan_bill");
     params.put("request", condition);

     return XfR.ok(financialPersonLoanBillServiceImpl.querys(params));
  }

}
