package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPurchasePaymentBill;
import com.xforceplus.financialsettlement.service.IFinancialPurchasePaymentBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class FinancialPurchasePaymentBillController {

  @Autowired
  private IFinancialPurchasePaymentBillService financialPurchasePaymentBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchasePaymentBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasepaymentbills" )
  public XfR getFinancialPurchasePaymentBills(XfPage page, FinancialPurchasePaymentBill financialPurchasePaymentBill) {
    return XfR.ok(financialPurchasePaymentBillServiceImpl.page(page, Wrappers.query(financialPurchasePaymentBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasepaymentbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchasePaymentBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchasePaymentBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasepaymentbills")
  public XfR save(@RequestBody FinancialPurchasePaymentBill financialPurchasePaymentBill) {
     return XfR.ok(financialPurchasePaymentBillServiceImpl.save(financialPurchasePaymentBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchasePaymentBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasepaymentbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchasePaymentBill financialPurchasePaymentBill,@PathVariable Long id) {
      financialPurchasePaymentBill.setId(id);
      return XfR.ok(financialPurchasePaymentBillServiceImpl.updateById(financialPurchasePaymentBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchasePaymentBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasepaymentbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchasePaymentBill financialPurchasePaymentBill,@PathVariable Long id) {
      FinancialPurchasePaymentBill upfinancialPurchasePaymentBill = financialPurchasePaymentBillServiceImpl.getById(id);
      if(upfinancialPurchasePaymentBill != null){
        upfinancialPurchasePaymentBill = ObjectCopyUtils.copyProperties(financialPurchasePaymentBill,upfinancialPurchasePaymentBill,true);
      }
      return XfR.ok(financialPurchasePaymentBillServiceImpl.updateById(upfinancialPurchasePaymentBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasepaymentbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchasePaymentBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasepaymentbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_payment_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchasePaymentBillServiceImpl.querys(params));
  }

}
