package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.LegalEntityBudgetCenterMapping;
import com.xforceplus.financialsettlement.service.ILegalEntityBudgetCenterMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class LegalEntityBudgetCenterMappingController {

  @Autowired
  private ILegalEntityBudgetCenterMappingService legalEntityBudgetCenterMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param legalEntityBudgetCenterMapping ${table.comment}
   * @return
   */
  @GetMapping("/legalentitybudgetcentermappings" )
  public XfR getLegalEntityBudgetCenterMappings(XfPage page, LegalEntityBudgetCenterMapping legalEntityBudgetCenterMapping) {
    return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.page(page, Wrappers.query(legalEntityBudgetCenterMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/legalentitybudgetcentermappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param legalEntityBudgetCenterMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/legalentitybudgetcentermappings")
  public XfR save(@RequestBody LegalEntityBudgetCenterMapping legalEntityBudgetCenterMapping) {
     return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.save(legalEntityBudgetCenterMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param legalEntityBudgetCenterMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/legalentitybudgetcentermappings/{id}")
  public XfR putUpdate(@RequestBody LegalEntityBudgetCenterMapping legalEntityBudgetCenterMapping,@PathVariable Long id) {
      legalEntityBudgetCenterMapping.setId(id);
      return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.updateById(legalEntityBudgetCenterMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param legalEntityBudgetCenterMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/legalentitybudgetcentermappings/{id}")
  public XfR patchUpdate(@RequestBody LegalEntityBudgetCenterMapping legalEntityBudgetCenterMapping,@PathVariable Long id) {
      LegalEntityBudgetCenterMapping uplegalEntityBudgetCenterMapping = legalEntityBudgetCenterMappingServiceImpl.getById(id);
      if(uplegalEntityBudgetCenterMapping != null){
        uplegalEntityBudgetCenterMapping = ObjectCopyUtils.copyProperties(legalEntityBudgetCenterMapping,uplegalEntityBudgetCenterMapping,true);
      }
      return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.updateById(uplegalEntityBudgetCenterMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/legalentitybudgetcentermappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.removeById(id));
  }

  @PostMapping("/legalentitybudgetcentermappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "legal_entity_budget_center_mapping");
     params.put("request", condition);

     return XfR.ok(legalEntityBudgetCenterMappingServiceImpl.querys(params));
  }

}
