package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ProjectBasicInfo;
import com.xforceplus.financialsettlement.service.IProjectBasicInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 项目基础信息前端控制器
 *
 * @author ultraman
 * @date 2023-10-09
 */
@RestController
public class ProjectBasicInfoController {

  @Autowired
  private IProjectBasicInfoService projectBasicInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectBasicInfo 项目基础信息
   * @return
   */
  @GetMapping("/projectbasicinfos" )
  public XfR getProjectBasicInfos(XfPage page, ProjectBasicInfo projectBasicInfo) {
    return XfR.ok(projectBasicInfoServiceImpl.page(page, Wrappers.query(projectBasicInfo)));
  }

  /**
   * 通过id查询项目基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectbasicinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectBasicInfoServiceImpl.getById(id));
  }

  /**
   * 新增项目基础信息
   * @param projectBasicInfo 项目基础信息
   * @return XfR
   */
  @PostMapping("/projectbasicinfos")
  public XfR save(@RequestBody ProjectBasicInfo projectBasicInfo) {
     return XfR.ok(projectBasicInfoServiceImpl.save(projectBasicInfo));
  }

  /**
   * 修改-传入修改后的全部数据项目基础信息
   * @param projectBasicInfo 项目基础信息
   * @return XfR
   */
  @PutMapping("/projectbasicinfos/{id}")
  public XfR putUpdate(@RequestBody ProjectBasicInfo projectBasicInfo,@PathVariable Long id) {
      projectBasicInfo.setId(id);
      return XfR.ok(projectBasicInfoServiceImpl.updateById(projectBasicInfo));
  }

  /**
   * 修改-传入修改的数据项目基础信息
   * @param projectBasicInfo 项目基础信息
   * @return XfR
   */
  @PatchMapping("/projectbasicinfos/{id}")
  public XfR patchUpdate(@RequestBody ProjectBasicInfo projectBasicInfo,@PathVariable Long id) {
      ProjectBasicInfo upprojectBasicInfo = projectBasicInfoServiceImpl.getById(id);
      if(upprojectBasicInfo != null){
        upprojectBasicInfo = ObjectCopyUtils.copyProperties(projectBasicInfo,upprojectBasicInfo,true);
      }
      return XfR.ok(projectBasicInfoServiceImpl.updateById(upprojectBasicInfo));
  }

  /**
   * 通过id删除项目基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectbasicinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectBasicInfoServiceImpl.removeById(id));
  }

  @PostMapping("/projectbasicinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_basic_info");
     params.put("request", condition);

     return XfR.ok(projectBasicInfoServiceImpl.querys(params));
  }

}
