package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPurchaseRedAdjustBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialPurchaseRedAdjustBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-27
 */
@RestController
public class FinancialPurchaseRedAdjustBillDetailController {

  @Autowired
  private IFinancialPurchaseRedAdjustBillDetailService financialPurchaseRedAdjustBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseRedAdjustBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchaseredadjustbilldetails" )
  public XfR getFinancialPurchaseRedAdjustBillDetails(XfPage page, FinancialPurchaseRedAdjustBillDetail financialPurchaseRedAdjustBillDetail) {
    return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.page(page, Wrappers.query(financialPurchaseRedAdjustBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchaseredadjustbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseRedAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchaseredadjustbilldetails")
  public XfR save(@RequestBody FinancialPurchaseRedAdjustBillDetail financialPurchaseRedAdjustBillDetail) {
     return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.save(financialPurchaseRedAdjustBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseRedAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchaseredadjustbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseRedAdjustBillDetail financialPurchaseRedAdjustBillDetail,@PathVariable Long id) {
      financialPurchaseRedAdjustBillDetail.setId(id);
      return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.updateById(financialPurchaseRedAdjustBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseRedAdjustBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchaseredadjustbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseRedAdjustBillDetail financialPurchaseRedAdjustBillDetail,@PathVariable Long id) {
      FinancialPurchaseRedAdjustBillDetail upfinancialPurchaseRedAdjustBillDetail = financialPurchaseRedAdjustBillDetailServiceImpl.getById(id);
      if(upfinancialPurchaseRedAdjustBillDetail != null){
        upfinancialPurchaseRedAdjustBillDetail = ObjectCopyUtils.copyProperties(financialPurchaseRedAdjustBillDetail,upfinancialPurchaseRedAdjustBillDetail,true);
      }
      return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.updateById(upfinancialPurchaseRedAdjustBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchaseredadjustbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchaseredadjustbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_red_adjust_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialPurchaseRedAdjustBillDetailServiceImpl.querys(params));
  }

}
