package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FkjApplyFaceBillImage;
import com.xforceplus.financialsettlement.service.IFkjApplyFaceBillImageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-27
 */
@RestController
public class FkjApplyFaceBillImageController {

  @Autowired
  private IFkjApplyFaceBillImageService fkjApplyFaceBillImageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fkjApplyFaceBillImage ${table.comment}
   * @return
   */
  @GetMapping("/fkjapplyfacebillimages" )
  public XfR getFkjApplyFaceBillImages(XfPage page, FkjApplyFaceBillImage fkjApplyFaceBillImage) {
    return XfR.ok(fkjApplyFaceBillImageServiceImpl.page(page, Wrappers.query(fkjApplyFaceBillImage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fkjapplyfacebillimages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fkjApplyFaceBillImageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fkjApplyFaceBillImage ${table.comment}
   * @return XfR
   */
  @PostMapping("/fkjapplyfacebillimages")
  public XfR save(@RequestBody FkjApplyFaceBillImage fkjApplyFaceBillImage) {
     return XfR.ok(fkjApplyFaceBillImageServiceImpl.save(fkjApplyFaceBillImage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fkjApplyFaceBillImage ${table.comment}
   * @return XfR
   */
  @PutMapping("/fkjapplyfacebillimages/{id}")
  public XfR putUpdate(@RequestBody FkjApplyFaceBillImage fkjApplyFaceBillImage,@PathVariable Long id) {
      fkjApplyFaceBillImage.setId(id);
      return XfR.ok(fkjApplyFaceBillImageServiceImpl.updateById(fkjApplyFaceBillImage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fkjApplyFaceBillImage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fkjapplyfacebillimages/{id}")
  public XfR patchUpdate(@RequestBody FkjApplyFaceBillImage fkjApplyFaceBillImage,@PathVariable Long id) {
      FkjApplyFaceBillImage upfkjApplyFaceBillImage = fkjApplyFaceBillImageServiceImpl.getById(id);
      if(upfkjApplyFaceBillImage != null){
        upfkjApplyFaceBillImage = ObjectCopyUtils.copyProperties(fkjApplyFaceBillImage,upfkjApplyFaceBillImage,true);
      }
      return XfR.ok(fkjApplyFaceBillImageServiceImpl.updateById(upfkjApplyFaceBillImage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fkjapplyfacebillimages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fkjApplyFaceBillImageServiceImpl.removeById(id));
  }

  @PostMapping("/fkjapplyfacebillimages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fkj_apply_face_bill_image");
     params.put("request", condition);

     return XfR.ok(fkjApplyFaceBillImageServiceImpl.querys(params));
  }

}
