package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.SmallCentreTenantMapping;
import com.xforceplus.financialsettlement.service.ISmallCentreTenantMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-27
 */
@RestController
public class SmallCentreTenantMappingController {

  @Autowired
  private ISmallCentreTenantMappingService smallCentreTenantMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param smallCentreTenantMapping ${table.comment}
   * @return
   */
  @GetMapping("/smallcentretenantmappings" )
  public XfR getSmallCentreTenantMappings(XfPage page, SmallCentreTenantMapping smallCentreTenantMapping) {
    return XfR.ok(smallCentreTenantMappingServiceImpl.page(page, Wrappers.query(smallCentreTenantMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/smallcentretenantmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(smallCentreTenantMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param smallCentreTenantMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/smallcentretenantmappings")
  public XfR save(@RequestBody SmallCentreTenantMapping smallCentreTenantMapping) {
     return XfR.ok(smallCentreTenantMappingServiceImpl.save(smallCentreTenantMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param smallCentreTenantMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/smallcentretenantmappings/{id}")
  public XfR putUpdate(@RequestBody SmallCentreTenantMapping smallCentreTenantMapping,@PathVariable Long id) {
      smallCentreTenantMapping.setId(id);
      return XfR.ok(smallCentreTenantMappingServiceImpl.updateById(smallCentreTenantMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param smallCentreTenantMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/smallcentretenantmappings/{id}")
  public XfR patchUpdate(@RequestBody SmallCentreTenantMapping smallCentreTenantMapping,@PathVariable Long id) {
      SmallCentreTenantMapping upsmallCentreTenantMapping = smallCentreTenantMappingServiceImpl.getById(id);
      if(upsmallCentreTenantMapping != null){
        upsmallCentreTenantMapping = ObjectCopyUtils.copyProperties(smallCentreTenantMapping,upsmallCentreTenantMapping,true);
      }
      return XfR.ok(smallCentreTenantMappingServiceImpl.updateById(upsmallCentreTenantMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/smallcentretenantmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(smallCentreTenantMappingServiceImpl.removeById(id));
  }

  @PostMapping("/smallcentretenantmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "small_centre_tenant_mapping");
     params.put("request", condition);

     return XfR.ok(smallCentreTenantMappingServiceImpl.querys(params));
  }

}
