package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeTypeCostSnapshot;
import com.xforceplus.financialsettlement.service.IChargeCodeTypeCostSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2023-11-22
 */
@RestController
public class ChargeCodeTypeCostSnapshotController {

  @Autowired
  private IChargeCodeTypeCostSnapshotService chargeCodeTypeCostSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeTypeCostSnapshot 
   * @return
   */
  @GetMapping("/chargecodetypecostsnapshots" )
  public XfR getChargeCodeTypeCostSnapshots(XfPage page, ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot) {
    return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.page(page, Wrappers.query(chargeCodeTypeCostSnapshot)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodetypecostsnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param chargeCodeTypeCostSnapshot 
   * @return XfR
   */
  @PostMapping("/chargecodetypecostsnapshots")
  public XfR save(@RequestBody ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot) {
     return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.save(chargeCodeTypeCostSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param chargeCodeTypeCostSnapshot 
   * @return XfR
   */
  @PutMapping("/chargecodetypecostsnapshots/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot,@PathVariable Long id) {
      chargeCodeTypeCostSnapshot.setId(id);
      return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.updateById(chargeCodeTypeCostSnapshot));
  }

  /**
   * 修改-传入修改的数据
   * @param chargeCodeTypeCostSnapshot 
   * @return XfR
   */
  @PatchMapping("/chargecodetypecostsnapshots/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeTypeCostSnapshot chargeCodeTypeCostSnapshot,@PathVariable Long id) {
      ChargeCodeTypeCostSnapshot upchargeCodeTypeCostSnapshot = chargeCodeTypeCostSnapshotServiceImpl.getById(id);
      if(upchargeCodeTypeCostSnapshot != null){
        upchargeCodeTypeCostSnapshot = ObjectCopyUtils.copyProperties(chargeCodeTypeCostSnapshot,upchargeCodeTypeCostSnapshot,true);
      }
      return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.updateById(upchargeCodeTypeCostSnapshot));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodetypecostsnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodetypecostsnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_type_cost_snapshot");
     params.put("request", condition);

     return XfR.ok(chargeCodeTypeCostSnapshotServiceImpl.querys(params));
  }

}
