package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderInvoiceImportData;
import com.xforceplus.financialsettlement.service.IOrderInvoiceImportDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-22
 */
@RestController
public class OrderInvoiceImportDataController {

  @Autowired
  private IOrderInvoiceImportDataService orderInvoiceImportDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInvoiceImportData ${table.comment}
   * @return
   */
  @GetMapping("/orderinvoiceimportdatas" )
  public XfR getOrderInvoiceImportDatas(XfPage page, OrderInvoiceImportData orderInvoiceImportData) {
    return XfR.ok(orderInvoiceImportDataServiceImpl.page(page, Wrappers.query(orderInvoiceImportData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinvoiceimportdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInvoiceImportDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderInvoiceImportData ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderinvoiceimportdatas")
  public XfR save(@RequestBody OrderInvoiceImportData orderInvoiceImportData) {
     return XfR.ok(orderInvoiceImportDataServiceImpl.save(orderInvoiceImportData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderInvoiceImportData ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderinvoiceimportdatas/{id}")
  public XfR putUpdate(@RequestBody OrderInvoiceImportData orderInvoiceImportData,@PathVariable Long id) {
      orderInvoiceImportData.setId(id);
      return XfR.ok(orderInvoiceImportDataServiceImpl.updateById(orderInvoiceImportData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderInvoiceImportData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderinvoiceimportdatas/{id}")
  public XfR patchUpdate(@RequestBody OrderInvoiceImportData orderInvoiceImportData,@PathVariable Long id) {
      OrderInvoiceImportData uporderInvoiceImportData = orderInvoiceImportDataServiceImpl.getById(id);
      if(uporderInvoiceImportData != null){
        uporderInvoiceImportData = ObjectCopyUtils.copyProperties(orderInvoiceImportData,uporderInvoiceImportData,true);
      }
      return XfR.ok(orderInvoiceImportDataServiceImpl.updateById(uporderInvoiceImportData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinvoiceimportdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInvoiceImportDataServiceImpl.removeById(id));
  }

  @PostMapping("/orderinvoiceimportdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_invoice_import_data");
     params.put("request", condition);

     return XfR.ok(orderInvoiceImportDataServiceImpl.querys(params));
  }

}
