package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CapitalVerifyRuleConfigField;
import com.xforceplus.financialsettlement.service.ICapitalVerifyRuleConfigFieldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-28
 */
@RestController
public class CapitalVerifyRuleConfigFieldController {

  @Autowired
  private ICapitalVerifyRuleConfigFieldService capitalVerifyRuleConfigFieldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param capitalVerifyRuleConfigField ${table.comment}
   * @return
   */
  @GetMapping("/capitalverifyruleconfigfields" )
  public XfR getCapitalVerifyRuleConfigFields(XfPage page, CapitalVerifyRuleConfigField capitalVerifyRuleConfigField) {
    return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.page(page, Wrappers.query(capitalVerifyRuleConfigField)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/capitalverifyruleconfigfields/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param capitalVerifyRuleConfigField ${table.comment}
   * @return XfR
   */
  @PostMapping("/capitalverifyruleconfigfields")
  public XfR save(@RequestBody CapitalVerifyRuleConfigField capitalVerifyRuleConfigField) {
     return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.save(capitalVerifyRuleConfigField));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param capitalVerifyRuleConfigField ${table.comment}
   * @return XfR
   */
  @PutMapping("/capitalverifyruleconfigfields/{id}")
  public XfR putUpdate(@RequestBody CapitalVerifyRuleConfigField capitalVerifyRuleConfigField,@PathVariable Long id) {
      capitalVerifyRuleConfigField.setId(id);
      return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.updateById(capitalVerifyRuleConfigField));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param capitalVerifyRuleConfigField ${table.comment}
   * @return XfR
   */
  @PatchMapping("/capitalverifyruleconfigfields/{id}")
  public XfR patchUpdate(@RequestBody CapitalVerifyRuleConfigField capitalVerifyRuleConfigField,@PathVariable Long id) {
      CapitalVerifyRuleConfigField upcapitalVerifyRuleConfigField = capitalVerifyRuleConfigFieldServiceImpl.getById(id);
      if(upcapitalVerifyRuleConfigField != null){
        upcapitalVerifyRuleConfigField = ObjectCopyUtils.copyProperties(capitalVerifyRuleConfigField,upcapitalVerifyRuleConfigField,true);
      }
      return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.updateById(upcapitalVerifyRuleConfigField));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/capitalverifyruleconfigfields/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.removeById(id));
  }

  @PostMapping("/capitalverifyruleconfigfields/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "capital_verify_rule_config_field");
     params.put("request", condition);

     return XfR.ok(capitalVerifyRuleConfigFieldServiceImpl.querys(params));
  }

}
