package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeBudgetUsageSyn;
import com.xforceplus.financialsettlement.service.IChargeCodeBudgetUsageSynService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-28
 */
@RestController
public class ChargeCodeBudgetUsageSynController {

  @Autowired
  private IChargeCodeBudgetUsageSynService chargeCodeBudgetUsageSynServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudgetUsageSyn ${table.comment}
   * @return
   */
  @GetMapping("/chargecodebudgetusagesyns" )
  public XfR getChargeCodeBudgetUsageSyns(XfPage page, ChargeCodeBudgetUsageSyn chargeCodeBudgetUsageSyn) {
    return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.page(page, Wrappers.query(chargeCodeBudgetUsageSyn)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgetusagesyns/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeBudgetUsageSyn ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodebudgetusagesyns")
  public XfR save(@RequestBody ChargeCodeBudgetUsageSyn chargeCodeBudgetUsageSyn) {
     return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.save(chargeCodeBudgetUsageSyn));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeBudgetUsageSyn ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodebudgetusagesyns/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudgetUsageSyn chargeCodeBudgetUsageSyn,@PathVariable Long id) {
      chargeCodeBudgetUsageSyn.setId(id);
      return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.updateById(chargeCodeBudgetUsageSyn));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeBudgetUsageSyn ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodebudgetusagesyns/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudgetUsageSyn chargeCodeBudgetUsageSyn,@PathVariable Long id) {
      ChargeCodeBudgetUsageSyn upchargeCodeBudgetUsageSyn = chargeCodeBudgetUsageSynServiceImpl.getById(id);
      if(upchargeCodeBudgetUsageSyn != null){
        upchargeCodeBudgetUsageSyn = ObjectCopyUtils.copyProperties(chargeCodeBudgetUsageSyn,upchargeCodeBudgetUsageSyn,true);
      }
      return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.updateById(upchargeCodeBudgetUsageSyn));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgetusagesyns/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgetusagesyns/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget_usage_syn");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetUsageSynServiceImpl.querys(params));
  }

}
