package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialTravelApplyBill;
import com.xforceplus.financialsettlement.service.IFinancialTravelApplyBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-28
 */
@RestController
public class FinancialTravelApplyBillController {

  @Autowired
  private IFinancialTravelApplyBillService financialTravelApplyBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTravelApplyBill ${table.comment}
   * @return
   */
  @GetMapping("/financialtravelapplybills" )
  public XfR getFinancialTravelApplyBills(XfPage page, FinancialTravelApplyBill financialTravelApplyBill) {
    return XfR.ok(financialTravelApplyBillServiceImpl.page(page, Wrappers.query(financialTravelApplyBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialtravelapplybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTravelApplyBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialTravelApplyBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialtravelapplybills")
  public XfR save(@RequestBody FinancialTravelApplyBill financialTravelApplyBill) {
     return XfR.ok(financialTravelApplyBillServiceImpl.save(financialTravelApplyBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialTravelApplyBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialtravelapplybills/{id}")
  public XfR putUpdate(@RequestBody FinancialTravelApplyBill financialTravelApplyBill,@PathVariable Long id) {
      financialTravelApplyBill.setId(id);
      return XfR.ok(financialTravelApplyBillServiceImpl.updateById(financialTravelApplyBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialTravelApplyBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialtravelapplybills/{id}")
  public XfR patchUpdate(@RequestBody FinancialTravelApplyBill financialTravelApplyBill,@PathVariable Long id) {
      FinancialTravelApplyBill upfinancialTravelApplyBill = financialTravelApplyBillServiceImpl.getById(id);
      if(upfinancialTravelApplyBill != null){
        upfinancialTravelApplyBill = ObjectCopyUtils.copyProperties(financialTravelApplyBill,upfinancialTravelApplyBill,true);
      }
      return XfR.ok(financialTravelApplyBillServiceImpl.updateById(upfinancialTravelApplyBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialtravelapplybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTravelApplyBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialtravelapplybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_travel_apply_bill");
     params.put("request", condition);

     return XfR.ok(financialTravelApplyBillServiceImpl.querys(params));
  }

}
