package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.PreComputeTaxAmountInfo;
import com.xforceplus.financialsettlement.service.IPreComputeTaxAmountInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-28
 */
@RestController
public class PreComputeTaxAmountInfoController {

  @Autowired
  private IPreComputeTaxAmountInfoService preComputeTaxAmountInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preComputeTaxAmountInfo ${table.comment}
   * @return
   */
  @GetMapping("/precomputetaxamountinfos" )
  public XfR getPreComputeTaxAmountInfos(XfPage page, PreComputeTaxAmountInfo preComputeTaxAmountInfo) {
    return XfR.ok(preComputeTaxAmountInfoServiceImpl.page(page, Wrappers.query(preComputeTaxAmountInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/precomputetaxamountinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preComputeTaxAmountInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preComputeTaxAmountInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/precomputetaxamountinfos")
  public XfR save(@RequestBody PreComputeTaxAmountInfo preComputeTaxAmountInfo) {
     return XfR.ok(preComputeTaxAmountInfoServiceImpl.save(preComputeTaxAmountInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preComputeTaxAmountInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/precomputetaxamountinfos/{id}")
  public XfR putUpdate(@RequestBody PreComputeTaxAmountInfo preComputeTaxAmountInfo,@PathVariable Long id) {
      preComputeTaxAmountInfo.setId(id);
      return XfR.ok(preComputeTaxAmountInfoServiceImpl.updateById(preComputeTaxAmountInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preComputeTaxAmountInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/precomputetaxamountinfos/{id}")
  public XfR patchUpdate(@RequestBody PreComputeTaxAmountInfo preComputeTaxAmountInfo,@PathVariable Long id) {
      PreComputeTaxAmountInfo uppreComputeTaxAmountInfo = preComputeTaxAmountInfoServiceImpl.getById(id);
      if(uppreComputeTaxAmountInfo != null){
        uppreComputeTaxAmountInfo = ObjectCopyUtils.copyProperties(preComputeTaxAmountInfo,uppreComputeTaxAmountInfo,true);
      }
      return XfR.ok(preComputeTaxAmountInfoServiceImpl.updateById(uppreComputeTaxAmountInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/precomputetaxamountinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preComputeTaxAmountInfoServiceImpl.removeById(id));
  }

  @PostMapping("/precomputetaxamountinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pre_compute_tax_amount_info");
     params.put("request", condition);

     return XfR.ok(preComputeTaxAmountInfoServiceImpl.querys(params));
  }

}
