package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReceivedPaymentsNotTaken;
import com.xforceplus.financialsettlement.service.IReceivedPaymentsNotTakenService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-28
 */
@RestController
public class ReceivedPaymentsNotTakenController {

  @Autowired
  private IReceivedPaymentsNotTakenService receivedPaymentsNotTakenServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivedPaymentsNotTaken ${table.comment}
   * @return
   */
  @GetMapping("/receivedpaymentsnottakens" )
  public XfR getReceivedPaymentsNotTakens(XfPage page, ReceivedPaymentsNotTaken receivedPaymentsNotTaken) {
    return XfR.ok(receivedPaymentsNotTakenServiceImpl.page(page, Wrappers.query(receivedPaymentsNotTaken)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivedpaymentsnottakens/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsNotTakenServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivedPaymentsNotTaken ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivedpaymentsnottakens")
  public XfR save(@RequestBody ReceivedPaymentsNotTaken receivedPaymentsNotTaken) {
     return XfR.ok(receivedPaymentsNotTakenServiceImpl.save(receivedPaymentsNotTaken));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivedPaymentsNotTaken ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivedpaymentsnottakens/{id}")
  public XfR putUpdate(@RequestBody ReceivedPaymentsNotTaken receivedPaymentsNotTaken,@PathVariable Long id) {
      receivedPaymentsNotTaken.setId(id);
      return XfR.ok(receivedPaymentsNotTakenServiceImpl.updateById(receivedPaymentsNotTaken));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivedPaymentsNotTaken ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivedpaymentsnottakens/{id}")
  public XfR patchUpdate(@RequestBody ReceivedPaymentsNotTaken receivedPaymentsNotTaken,@PathVariable Long id) {
      ReceivedPaymentsNotTaken upreceivedPaymentsNotTaken = receivedPaymentsNotTakenServiceImpl.getById(id);
      if(upreceivedPaymentsNotTaken != null){
        upreceivedPaymentsNotTaken = ObjectCopyUtils.copyProperties(receivedPaymentsNotTaken,upreceivedPaymentsNotTaken,true);
      }
      return XfR.ok(receivedPaymentsNotTakenServiceImpl.updateById(upreceivedPaymentsNotTaken));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivedpaymentsnottakens/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsNotTakenServiceImpl.removeById(id));
  }

  @PostMapping("/receivedpaymentsnottakens/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "received_payments_not_taken");
     params.put("request", condition);

     return XfR.ok(receivedPaymentsNotTakenServiceImpl.querys(params));
  }

}
