package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.EmployeeConsumeCost;
import com.xforceplus.financialsettlement.service.IEmployeeConsumeCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class EmployeeConsumeCostController {

  @Autowired
  private IEmployeeConsumeCostService employeeConsumeCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param employeeConsumeCost ${table.comment}
   * @return
   */
  @GetMapping("/employeeconsumecosts" )
  public XfR getEmployeeConsumeCosts(XfPage page, EmployeeConsumeCost employeeConsumeCost) {
    return XfR.ok(employeeConsumeCostServiceImpl.page(page, Wrappers.query(employeeConsumeCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/employeeconsumecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(employeeConsumeCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param employeeConsumeCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/employeeconsumecosts")
  public XfR save(@RequestBody EmployeeConsumeCost employeeConsumeCost) {
     return XfR.ok(employeeConsumeCostServiceImpl.save(employeeConsumeCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param employeeConsumeCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/employeeconsumecosts/{id}")
  public XfR putUpdate(@RequestBody EmployeeConsumeCost employeeConsumeCost,@PathVariable Long id) {
      employeeConsumeCost.setId(id);
      return XfR.ok(employeeConsumeCostServiceImpl.updateById(employeeConsumeCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param employeeConsumeCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/employeeconsumecosts/{id}")
  public XfR patchUpdate(@RequestBody EmployeeConsumeCost employeeConsumeCost,@PathVariable Long id) {
      EmployeeConsumeCost upemployeeConsumeCost = employeeConsumeCostServiceImpl.getById(id);
      if(upemployeeConsumeCost != null){
        upemployeeConsumeCost = ObjectCopyUtils.copyProperties(employeeConsumeCost,upemployeeConsumeCost,true);
      }
      return XfR.ok(employeeConsumeCostServiceImpl.updateById(upemployeeConsumeCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/employeeconsumecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(employeeConsumeCostServiceImpl.removeById(id));
  }

  @PostMapping("/employeeconsumecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "employee_consume_cost");
     params.put("request", condition);

     return XfR.ok(employeeConsumeCostServiceImpl.querys(params));
  }

}
