package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.MemberRoleCost;
import com.xforceplus.financialsettlement.service.IMemberRoleCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class MemberRoleCostController {

  @Autowired
  private IMemberRoleCostService memberRoleCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param memberRoleCost ${table.comment}
   * @return
   */
  @GetMapping("/memberrolecosts" )
  public XfR getMemberRoleCosts(XfPage page, MemberRoleCost memberRoleCost) {
    return XfR.ok(memberRoleCostServiceImpl.page(page, Wrappers.query(memberRoleCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/memberrolecosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberRoleCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param memberRoleCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/memberrolecosts")
  public XfR save(@RequestBody MemberRoleCost memberRoleCost) {
     return XfR.ok(memberRoleCostServiceImpl.save(memberRoleCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param memberRoleCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/memberrolecosts/{id}")
  public XfR putUpdate(@RequestBody MemberRoleCost memberRoleCost,@PathVariable Long id) {
      memberRoleCost.setId(id);
      return XfR.ok(memberRoleCostServiceImpl.updateById(memberRoleCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param memberRoleCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/memberrolecosts/{id}")
  public XfR patchUpdate(@RequestBody MemberRoleCost memberRoleCost,@PathVariable Long id) {
      MemberRoleCost upmemberRoleCost = memberRoleCostServiceImpl.getById(id);
      if(upmemberRoleCost != null){
        upmemberRoleCost = ObjectCopyUtils.copyProperties(memberRoleCost,upmemberRoleCost,true);
      }
      return XfR.ok(memberRoleCostServiceImpl.updateById(upmemberRoleCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/memberrolecosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberRoleCostServiceImpl.removeById(id));
  }

  @PostMapping("/memberrolecosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member_role_cost");
     params.put("request", condition);

     return XfR.ok(memberRoleCostServiceImpl.querys(params));
  }

}
