package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ProjectInfoUnderContract;
import com.xforceplus.financialsettlement.service.IProjectInfoUnderContractService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-11
 */
@RestController
public class ProjectInfoUnderContractController {

  @Autowired
  private IProjectInfoUnderContractService projectInfoUnderContractServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectInfoUnderContract ${table.comment}
   * @return
   */
  @GetMapping("/projectinfoundercontracts" )
  public XfR getProjectInfoUnderContracts(XfPage page, ProjectInfoUnderContract projectInfoUnderContract) {
    return XfR.ok(projectInfoUnderContractServiceImpl.page(page, Wrappers.query(projectInfoUnderContract)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectinfoundercontracts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectInfoUnderContractServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectInfoUnderContract ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectinfoundercontracts")
  public XfR save(@RequestBody ProjectInfoUnderContract projectInfoUnderContract) {
     return XfR.ok(projectInfoUnderContractServiceImpl.save(projectInfoUnderContract));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectInfoUnderContract ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectinfoundercontracts/{id}")
  public XfR putUpdate(@RequestBody ProjectInfoUnderContract projectInfoUnderContract,@PathVariable Long id) {
      projectInfoUnderContract.setId(id);
      return XfR.ok(projectInfoUnderContractServiceImpl.updateById(projectInfoUnderContract));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectInfoUnderContract ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectinfoundercontracts/{id}")
  public XfR patchUpdate(@RequestBody ProjectInfoUnderContract projectInfoUnderContract,@PathVariable Long id) {
      ProjectInfoUnderContract upprojectInfoUnderContract = projectInfoUnderContractServiceImpl.getById(id);
      if(upprojectInfoUnderContract != null){
        upprojectInfoUnderContract = ObjectCopyUtils.copyProperties(projectInfoUnderContract,upprojectInfoUnderContract,true);
      }
      return XfR.ok(projectInfoUnderContractServiceImpl.updateById(upprojectInfoUnderContract));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectinfoundercontracts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectInfoUnderContractServiceImpl.removeById(id));
  }

  @PostMapping("/projectinfoundercontracts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_info_under_contract");
     params.put("request", condition);

     return XfR.ok(projectInfoUnderContractServiceImpl.querys(params));
  }

}
