package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.BankDetailFilter;
import com.xforceplus.financialsettlement.service.IBankDetailFilterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class BankDetailFilterController {

  @Autowired
  private IBankDetailFilterService bankDetailFilterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bankDetailFilter ${table.comment}
   * @return
   */
  @GetMapping("/bankdetailfilters" )
  public XfR getBankDetailFilters(XfPage page, BankDetailFilter bankDetailFilter) {
    return XfR.ok(bankDetailFilterServiceImpl.page(page, Wrappers.query(bankDetailFilter)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bankdetailfilters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bankDetailFilterServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bankDetailFilter ${table.comment}
   * @return XfR
   */
  @PostMapping("/bankdetailfilters")
  public XfR save(@RequestBody BankDetailFilter bankDetailFilter) {
     return XfR.ok(bankDetailFilterServiceImpl.save(bankDetailFilter));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bankDetailFilter ${table.comment}
   * @return XfR
   */
  @PutMapping("/bankdetailfilters/{id}")
  public XfR putUpdate(@RequestBody BankDetailFilter bankDetailFilter,@PathVariable Long id) {
      bankDetailFilter.setId(id);
      return XfR.ok(bankDetailFilterServiceImpl.updateById(bankDetailFilter));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bankDetailFilter ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bankdetailfilters/{id}")
  public XfR patchUpdate(@RequestBody BankDetailFilter bankDetailFilter,@PathVariable Long id) {
      BankDetailFilter upbankDetailFilter = bankDetailFilterServiceImpl.getById(id);
      if(upbankDetailFilter != null){
        upbankDetailFilter = ObjectCopyUtils.copyProperties(bankDetailFilter,upbankDetailFilter,true);
      }
      return XfR.ok(bankDetailFilterServiceImpl.updateById(upbankDetailFilter));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bankdetailfilters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bankDetailFilterServiceImpl.removeById(id));
  }

  @PostMapping("/bankdetailfilters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bank_detail_filter");
     params.put("request", condition);

     return XfR.ok(bankDetailFilterServiceImpl.querys(params));
  }

}
