package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargecodeTypeOrgMapping;
import com.xforceplus.financialsettlement.service.IChargecodeTypeOrgMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class ChargecodeTypeOrgMappingController {

  @Autowired
  private IChargecodeTypeOrgMappingService chargecodeTypeOrgMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargecodeTypeOrgMapping ${table.comment}
   * @return
   */
  @GetMapping("/chargecodetypeorgmappings" )
  public XfR getChargecodeTypeOrgMappings(XfPage page, ChargecodeTypeOrgMapping chargecodeTypeOrgMapping) {
    return XfR.ok(chargecodeTypeOrgMappingServiceImpl.page(page, Wrappers.query(chargecodeTypeOrgMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodetypeorgmappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargecodeTypeOrgMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargecodeTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodetypeorgmappings")
  public XfR save(@RequestBody ChargecodeTypeOrgMapping chargecodeTypeOrgMapping) {
     return XfR.ok(chargecodeTypeOrgMappingServiceImpl.save(chargecodeTypeOrgMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargecodeTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodetypeorgmappings/{id}")
  public XfR putUpdate(@RequestBody ChargecodeTypeOrgMapping chargecodeTypeOrgMapping,@PathVariable Long id) {
      chargecodeTypeOrgMapping.setId(id);
      return XfR.ok(chargecodeTypeOrgMappingServiceImpl.updateById(chargecodeTypeOrgMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargecodeTypeOrgMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodetypeorgmappings/{id}")
  public XfR patchUpdate(@RequestBody ChargecodeTypeOrgMapping chargecodeTypeOrgMapping,@PathVariable Long id) {
      ChargecodeTypeOrgMapping upchargecodeTypeOrgMapping = chargecodeTypeOrgMappingServiceImpl.getById(id);
      if(upchargecodeTypeOrgMapping != null){
        upchargecodeTypeOrgMapping = ObjectCopyUtils.copyProperties(chargecodeTypeOrgMapping,upchargecodeTypeOrgMapping,true);
      }
      return XfR.ok(chargecodeTypeOrgMappingServiceImpl.updateById(upchargecodeTypeOrgMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodetypeorgmappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargecodeTypeOrgMappingServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodetypeorgmappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "chargecode_type_org_mapping");
     params.put("request", condition);

     return XfR.ok(chargecodeTypeOrgMappingServiceImpl.querys(params));
  }

}
