package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialHesWriteoffBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialHesWriteoffBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class FinancialHesWriteoffBillDetailController {

  @Autowired
  private IFinancialHesWriteoffBillDetailService financialHesWriteoffBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialHesWriteoffBillDetail ${table.comment}
   * @return
   */
  @GetMapping("/financialheswriteoffbilldetails" )
  public XfR getFinancialHesWriteoffBillDetails(XfPage page, FinancialHesWriteoffBillDetail financialHesWriteoffBillDetail) {
    return XfR.ok(financialHesWriteoffBillDetailServiceImpl.page(page, Wrappers.query(financialHesWriteoffBillDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialheswriteoffbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialHesWriteoffBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialHesWriteoffBillDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialheswriteoffbilldetails")
  public XfR save(@RequestBody FinancialHesWriteoffBillDetail financialHesWriteoffBillDetail) {
     return XfR.ok(financialHesWriteoffBillDetailServiceImpl.save(financialHesWriteoffBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialHesWriteoffBillDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialheswriteoffbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialHesWriteoffBillDetail financialHesWriteoffBillDetail,@PathVariable Long id) {
      financialHesWriteoffBillDetail.setId(id);
      return XfR.ok(financialHesWriteoffBillDetailServiceImpl.updateById(financialHesWriteoffBillDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialHesWriteoffBillDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialheswriteoffbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialHesWriteoffBillDetail financialHesWriteoffBillDetail,@PathVariable Long id) {
      FinancialHesWriteoffBillDetail upfinancialHesWriteoffBillDetail = financialHesWriteoffBillDetailServiceImpl.getById(id);
      if(upfinancialHesWriteoffBillDetail != null){
        upfinancialHesWriteoffBillDetail = ObjectCopyUtils.copyProperties(financialHesWriteoffBillDetail,upfinancialHesWriteoffBillDetail,true);
      }
      return XfR.ok(financialHesWriteoffBillDetailServiceImpl.updateById(upfinancialHesWriteoffBillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialheswriteoffbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialHesWriteoffBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialheswriteoffbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_hes_writeoff_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialHesWriteoffBillDetailServiceImpl.querys(params));
  }

}
