package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.YkbHsOrder;
import com.xforceplus.financialsettlement.service.IYkbHsOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2023-12-12
 */
@RestController
public class YkbHsOrderController {

  @Autowired
  private IYkbHsOrderService ykbHsOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ykbHsOrder 
   * @return
   */
  @GetMapping("/ykbhsorders" )
  public XfR getYkbHsOrders(XfPage page, YkbHsOrder ykbHsOrder) {
    return XfR.ok(ykbHsOrderServiceImpl.page(page, Wrappers.query(ykbHsOrder)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/ykbhsorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ykbHsOrderServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param ykbHsOrder 
   * @return XfR
   */
  @PostMapping("/ykbhsorders")
  public XfR save(@RequestBody YkbHsOrder ykbHsOrder) {
     return XfR.ok(ykbHsOrderServiceImpl.save(ykbHsOrder));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param ykbHsOrder 
   * @return XfR
   */
  @PutMapping("/ykbhsorders/{id}")
  public XfR putUpdate(@RequestBody YkbHsOrder ykbHsOrder,@PathVariable Long id) {
      ykbHsOrder.setId(id);
      return XfR.ok(ykbHsOrderServiceImpl.updateById(ykbHsOrder));
  }

  /**
   * 修改-传入修改的数据
   * @param ykbHsOrder 
   * @return XfR
   */
  @PatchMapping("/ykbhsorders/{id}")
  public XfR patchUpdate(@RequestBody YkbHsOrder ykbHsOrder,@PathVariable Long id) {
      YkbHsOrder upykbHsOrder = ykbHsOrderServiceImpl.getById(id);
      if(upykbHsOrder != null){
        upykbHsOrder = ObjectCopyUtils.copyProperties(ykbHsOrder,upykbHsOrder,true);
      }
      return XfR.ok(ykbHsOrderServiceImpl.updateById(upykbHsOrder));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ykbhsorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ykbHsOrderServiceImpl.removeById(id));
  }

  @PostMapping("/ykbhsorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ykb_hs_order");
     params.put("request", condition);

     return XfR.ok(ykbHsOrderServiceImpl.querys(params));
  }

}
