package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeBudgetPackge;
import com.xforceplus.financialsettlement.service.IChargeCodeBudgetPackgeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 预算包前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class ChargeCodeBudgetPackgeController {

  @Autowired
  private IChargeCodeBudgetPackgeService chargeCodeBudgetPackgeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeBudgetPackge 预算包
   * @return
   */
  @GetMapping("/chargecodebudgetpackges" )
  public XfR getChargeCodeBudgetPackges(XfPage page, ChargeCodeBudgetPackge chargeCodeBudgetPackge) {
    return XfR.ok(chargeCodeBudgetPackgeServiceImpl.page(page, Wrappers.query(chargeCodeBudgetPackge)));
  }

  /**
   * 通过id查询预算包
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodebudgetpackges/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetPackgeServiceImpl.getById(id));
  }

  /**
   * 新增预算包
   * @param chargeCodeBudgetPackge 预算包
   * @return XfR
   */
  @PostMapping("/chargecodebudgetpackges")
  public XfR save(@RequestBody ChargeCodeBudgetPackge chargeCodeBudgetPackge) {
     return XfR.ok(chargeCodeBudgetPackgeServiceImpl.save(chargeCodeBudgetPackge));
  }

  /**
   * 修改-传入修改后的全部数据预算包
   * @param chargeCodeBudgetPackge 预算包
   * @return XfR
   */
  @PutMapping("/chargecodebudgetpackges/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeBudgetPackge chargeCodeBudgetPackge,@PathVariable Long id) {
      chargeCodeBudgetPackge.setId(id);
      return XfR.ok(chargeCodeBudgetPackgeServiceImpl.updateById(chargeCodeBudgetPackge));
  }

  /**
   * 修改-传入修改的数据预算包
   * @param chargeCodeBudgetPackge 预算包
   * @return XfR
   */
  @PatchMapping("/chargecodebudgetpackges/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeBudgetPackge chargeCodeBudgetPackge,@PathVariable Long id) {
      ChargeCodeBudgetPackge upchargeCodeBudgetPackge = chargeCodeBudgetPackgeServiceImpl.getById(id);
      if(upchargeCodeBudgetPackge != null){
        upchargeCodeBudgetPackge = ObjectCopyUtils.copyProperties(chargeCodeBudgetPackge,upchargeCodeBudgetPackge,true);
      }
      return XfR.ok(chargeCodeBudgetPackgeServiceImpl.updateById(upchargeCodeBudgetPackge));
  }

  /**
   * 通过id删除预算包
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodebudgetpackges/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeBudgetPackgeServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodebudgetpackges/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_budget_packge");
     params.put("request", condition);

     return XfR.ok(chargeCodeBudgetPackgeServiceImpl.querys(params));
  }

}
