package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialBusinessServeReimbursementBill;
import com.xforceplus.financialsettlement.service.IFinancialBusinessServeReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class FinancialBusinessServeReimbursementBillController {

  @Autowired
  private IFinancialBusinessServeReimbursementBillService financialBusinessServeReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialBusinessServeReimbursementBill ${table.comment}
   * @return
   */
  @GetMapping("/financialbusinessservereimbursementbills" )
  public XfR getFinancialBusinessServeReimbursementBills(XfPage page, FinancialBusinessServeReimbursementBill financialBusinessServeReimbursementBill) {
    return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.page(page, Wrappers.query(financialBusinessServeReimbursementBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialbusinessservereimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialBusinessServeReimbursementBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialbusinessservereimbursementbills")
  public XfR save(@RequestBody FinancialBusinessServeReimbursementBill financialBusinessServeReimbursementBill) {
     return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.save(financialBusinessServeReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialBusinessServeReimbursementBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialbusinessservereimbursementbills/{id}")
  public XfR putUpdate(@RequestBody FinancialBusinessServeReimbursementBill financialBusinessServeReimbursementBill,@PathVariable Long id) {
      financialBusinessServeReimbursementBill.setId(id);
      return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.updateById(financialBusinessServeReimbursementBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialBusinessServeReimbursementBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialbusinessservereimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialBusinessServeReimbursementBill financialBusinessServeReimbursementBill,@PathVariable Long id) {
      FinancialBusinessServeReimbursementBill upfinancialBusinessServeReimbursementBill = financialBusinessServeReimbursementBillServiceImpl.getById(id);
      if(upfinancialBusinessServeReimbursementBill != null){
        upfinancialBusinessServeReimbursementBill = ObjectCopyUtils.copyProperties(financialBusinessServeReimbursementBill,upfinancialBusinessServeReimbursementBill,true);
      }
      return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.updateById(upfinancialBusinessServeReimbursementBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialbusinessservereimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialbusinessservereimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_business_serve_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(financialBusinessServeReimbursementBillServiceImpl.querys(params));
  }

}
