package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.IncomeItem;
import com.xforceplus.financialsettlement.service.IIncomeItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-18
 */
@RestController
public class IncomeItemController {

  @Autowired
  private IIncomeItemService incomeItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param incomeItem ${table.comment}
   * @return
   */
  @GetMapping("/incomeitems" )
  public XfR getIncomeItems(XfPage page, IncomeItem incomeItem) {
    return XfR.ok(incomeItemServiceImpl.page(page, Wrappers.query(incomeItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomeitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param incomeItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/incomeitems")
  public XfR save(@RequestBody IncomeItem incomeItem) {
     return XfR.ok(incomeItemServiceImpl.save(incomeItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param incomeItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/incomeitems/{id}")
  public XfR putUpdate(@RequestBody IncomeItem incomeItem,@PathVariable Long id) {
      incomeItem.setId(id);
      return XfR.ok(incomeItemServiceImpl.updateById(incomeItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param incomeItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/incomeitems/{id}")
  public XfR patchUpdate(@RequestBody IncomeItem incomeItem,@PathVariable Long id) {
      IncomeItem upincomeItem = incomeItemServiceImpl.getById(id);
      if(upincomeItem != null){
        upincomeItem = ObjectCopyUtils.copyProperties(incomeItem,upincomeItem,true);
      }
      return XfR.ok(incomeItemServiceImpl.updateById(upincomeItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomeitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeItemServiceImpl.removeById(id));
  }

  @PostMapping("/incomeitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income_item");
     params.put("request", condition);

     return XfR.ok(incomeItemServiceImpl.querys(params));
  }

}
