package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.CapitalFlowOperationRecord;
import com.xforceplus.financialsettlement.service.ICapitalFlowOperationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class CapitalFlowOperationRecordController {

  @Autowired
  private ICapitalFlowOperationRecordService capitalFlowOperationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param capitalFlowOperationRecord ${table.comment}
   * @return
   */
  @GetMapping("/capitalflowoperationrecords" )
  public XfR getCapitalFlowOperationRecords(XfPage page, CapitalFlowOperationRecord capitalFlowOperationRecord) {
    return XfR.ok(capitalFlowOperationRecordServiceImpl.page(page, Wrappers.query(capitalFlowOperationRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/capitalflowoperationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(capitalFlowOperationRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param capitalFlowOperationRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/capitalflowoperationrecords")
  public XfR save(@RequestBody CapitalFlowOperationRecord capitalFlowOperationRecord) {
     return XfR.ok(capitalFlowOperationRecordServiceImpl.save(capitalFlowOperationRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param capitalFlowOperationRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/capitalflowoperationrecords/{id}")
  public XfR putUpdate(@RequestBody CapitalFlowOperationRecord capitalFlowOperationRecord,@PathVariable Long id) {
      capitalFlowOperationRecord.setId(id);
      return XfR.ok(capitalFlowOperationRecordServiceImpl.updateById(capitalFlowOperationRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param capitalFlowOperationRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/capitalflowoperationrecords/{id}")
  public XfR patchUpdate(@RequestBody CapitalFlowOperationRecord capitalFlowOperationRecord,@PathVariable Long id) {
      CapitalFlowOperationRecord upcapitalFlowOperationRecord = capitalFlowOperationRecordServiceImpl.getById(id);
      if(upcapitalFlowOperationRecord != null){
        upcapitalFlowOperationRecord = ObjectCopyUtils.copyProperties(capitalFlowOperationRecord,upcapitalFlowOperationRecord,true);
      }
      return XfR.ok(capitalFlowOperationRecordServiceImpl.updateById(upcapitalFlowOperationRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/capitalflowoperationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(capitalFlowOperationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/capitalflowoperationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "capital_flow_operation_record");
     params.put("request", condition);

     return XfR.ok(capitalFlowOperationRecordServiceImpl.querys(params));
  }

}
