package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialApplyBasicBill;
import com.xforceplus.financialsettlement.service.IFinancialApplyBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class FinancialApplyBasicBillController {

  @Autowired
  private IFinancialApplyBasicBillService financialApplyBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialApplyBasicBill ${table.comment}
   * @return
   */
  @GetMapping("/financialapplybasicbills" )
  public XfR getFinancialApplyBasicBills(XfPage page, FinancialApplyBasicBill financialApplyBasicBill) {
    return XfR.ok(financialApplyBasicBillServiceImpl.page(page, Wrappers.query(financialApplyBasicBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialapplybasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialApplyBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialApplyBasicBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialapplybasicbills")
  public XfR save(@RequestBody FinancialApplyBasicBill financialApplyBasicBill) {
     return XfR.ok(financialApplyBasicBillServiceImpl.save(financialApplyBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialApplyBasicBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialapplybasicbills/{id}")
  public XfR putUpdate(@RequestBody FinancialApplyBasicBill financialApplyBasicBill,@PathVariable Long id) {
      financialApplyBasicBill.setId(id);
      return XfR.ok(financialApplyBasicBillServiceImpl.updateById(financialApplyBasicBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialApplyBasicBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialapplybasicbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialApplyBasicBill financialApplyBasicBill,@PathVariable Long id) {
      FinancialApplyBasicBill upfinancialApplyBasicBill = financialApplyBasicBillServiceImpl.getById(id);
      if(upfinancialApplyBasicBill != null){
        upfinancialApplyBasicBill = ObjectCopyUtils.copyProperties(financialApplyBasicBill,upfinancialApplyBasicBill,true);
      }
      return XfR.ok(financialApplyBasicBillServiceImpl.updateById(upfinancialApplyBasicBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialapplybasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialApplyBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialapplybasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_apply_basic_bill");
     params.put("request", condition);

     return XfR.ok(financialApplyBasicBillServiceImpl.querys(params));
  }

}
