package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialAssetsBill;
import com.xforceplus.financialsettlement.service.IFinancialAssetsBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 资产的领用及更换申请单前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class FinancialAssetsBillController {

  @Autowired
  private IFinancialAssetsBillService financialAssetsBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return
   */
  @GetMapping("/financialassetsbills" )
  public XfR getFinancialAssetsBills(XfPage page, FinancialAssetsBill financialAssetsBill) {
    return XfR.ok(financialAssetsBillServiceImpl.page(page, Wrappers.query(financialAssetsBill)));
  }

  /**
   * 通过id查询资产的领用及更换申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetsbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBillServiceImpl.getById(id));
  }

  /**
   * 新增资产的领用及更换申请单
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return XfR
   */
  @PostMapping("/financialassetsbills")
  public XfR save(@RequestBody FinancialAssetsBill financialAssetsBill) {
     return XfR.ok(financialAssetsBillServiceImpl.save(financialAssetsBill));
  }

  /**
   * 修改-传入修改后的全部数据资产的领用及更换申请单
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return XfR
   */
  @PutMapping("/financialassetsbills/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetsBill financialAssetsBill,@PathVariable Long id) {
      financialAssetsBill.setId(id);
      return XfR.ok(financialAssetsBillServiceImpl.updateById(financialAssetsBill));
  }

  /**
   * 修改-传入修改的数据资产的领用及更换申请单
   * @param financialAssetsBill 资产的领用及更换申请单
   * @return XfR
   */
  @PatchMapping("/financialassetsbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetsBill financialAssetsBill,@PathVariable Long id) {
      FinancialAssetsBill upfinancialAssetsBill = financialAssetsBillServiceImpl.getById(id);
      if(upfinancialAssetsBill != null){
        upfinancialAssetsBill = ObjectCopyUtils.copyProperties(financialAssetsBill,upfinancialAssetsBill,true);
      }
      return XfR.ok(financialAssetsBillServiceImpl.updateById(upfinancialAssetsBill));
  }

  /**
   * 通过id删除资产的领用及更换申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetsbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetsBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetsbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_assets_bill");
     params.put("request", condition);

     return XfR.ok(financialAssetsBillServiceImpl.querys(params));
  }

}
