package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialTeamBuildingBill;
import com.xforceplus.financialsettlement.service.IFinancialTeamBuildingBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 团建费报销单前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class FinancialTeamBuildingBillController {

  @Autowired
  private IFinancialTeamBuildingBillService financialTeamBuildingBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTeamBuildingBill 团建费报销单
   * @return
   */
  @GetMapping("/financialteambuildingbills" )
  public XfR getFinancialTeamBuildingBills(XfPage page, FinancialTeamBuildingBill financialTeamBuildingBill) {
    return XfR.ok(financialTeamBuildingBillServiceImpl.page(page, Wrappers.query(financialTeamBuildingBill)));
  }

  /**
   * 通过id查询团建费报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialteambuildingbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTeamBuildingBillServiceImpl.getById(id));
  }

  /**
   * 新增团建费报销单
   * @param financialTeamBuildingBill 团建费报销单
   * @return XfR
   */
  @PostMapping("/financialteambuildingbills")
  public XfR save(@RequestBody FinancialTeamBuildingBill financialTeamBuildingBill) {
     return XfR.ok(financialTeamBuildingBillServiceImpl.save(financialTeamBuildingBill));
  }

  /**
   * 修改-传入修改后的全部数据团建费报销单
   * @param financialTeamBuildingBill 团建费报销单
   * @return XfR
   */
  @PutMapping("/financialteambuildingbills/{id}")
  public XfR putUpdate(@RequestBody FinancialTeamBuildingBill financialTeamBuildingBill,@PathVariable Long id) {
      financialTeamBuildingBill.setId(id);
      return XfR.ok(financialTeamBuildingBillServiceImpl.updateById(financialTeamBuildingBill));
  }

  /**
   * 修改-传入修改的数据团建费报销单
   * @param financialTeamBuildingBill 团建费报销单
   * @return XfR
   */
  @PatchMapping("/financialteambuildingbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialTeamBuildingBill financialTeamBuildingBill,@PathVariable Long id) {
      FinancialTeamBuildingBill upfinancialTeamBuildingBill = financialTeamBuildingBillServiceImpl.getById(id);
      if(upfinancialTeamBuildingBill != null){
        upfinancialTeamBuildingBill = ObjectCopyUtils.copyProperties(financialTeamBuildingBill,upfinancialTeamBuildingBill,true);
      }
      return XfR.ok(financialTeamBuildingBillServiceImpl.updateById(upfinancialTeamBuildingBill));
  }

  /**
   * 通过id删除团建费报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialteambuildingbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTeamBuildingBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialteambuildingbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_team_building_bill");
     params.put("request", condition);

     return XfR.ok(financialTeamBuildingBillServiceImpl.querys(params));
  }

}
