package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderInfo;
import com.xforceplus.financialsettlement.service.IOrderInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class OrderInfoController {

  @Autowired
  private IOrderInfoService orderInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderInfo ${table.comment}
   * @return
   */
  @GetMapping("/orderinfos" )
  public XfR getOrderInfos(XfPage page, OrderInfo orderInfo) {
    return XfR.ok(orderInfoServiceImpl.page(page, Wrappers.query(orderInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderinfos")
  public XfR save(@RequestBody OrderInfo orderInfo) {
     return XfR.ok(orderInfoServiceImpl.save(orderInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderinfos/{id}")
  public XfR putUpdate(@RequestBody OrderInfo orderInfo,@PathVariable Long id) {
      orderInfo.setId(id);
      return XfR.ok(orderInfoServiceImpl.updateById(orderInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderinfos/{id}")
  public XfR patchUpdate(@RequestBody OrderInfo orderInfo,@PathVariable Long id) {
      OrderInfo uporderInfo = orderInfoServiceImpl.getById(id);
      if(uporderInfo != null){
        uporderInfo = ObjectCopyUtils.copyProperties(orderInfo,uporderInfo,true);
      }
      return XfR.ok(orderInfoServiceImpl.updateById(uporderInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderInfoServiceImpl.removeById(id));
  }

  @PostMapping("/orderinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_info");
     params.put("request", condition);

     return XfR.ok(orderInfoServiceImpl.querys(params));
  }

}
