package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ReceivedPaymentsNoNeed;
import com.xforceplus.financialsettlement.service.IReceivedPaymentsNoNeedService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class ReceivedPaymentsNoNeedController {

  @Autowired
  private IReceivedPaymentsNoNeedService receivedPaymentsNoNeedServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivedPaymentsNoNeed ${table.comment}
   * @return
   */
  @GetMapping("/receivedpaymentsnoneeds" )
  public XfR getReceivedPaymentsNoNeeds(XfPage page, ReceivedPaymentsNoNeed receivedPaymentsNoNeed) {
    return XfR.ok(receivedPaymentsNoNeedServiceImpl.page(page, Wrappers.query(receivedPaymentsNoNeed)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivedpaymentsnoneeds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsNoNeedServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivedPaymentsNoNeed ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivedpaymentsnoneeds")
  public XfR save(@RequestBody ReceivedPaymentsNoNeed receivedPaymentsNoNeed) {
     return XfR.ok(receivedPaymentsNoNeedServiceImpl.save(receivedPaymentsNoNeed));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivedPaymentsNoNeed ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivedpaymentsnoneeds/{id}")
  public XfR putUpdate(@RequestBody ReceivedPaymentsNoNeed receivedPaymentsNoNeed,@PathVariable Long id) {
      receivedPaymentsNoNeed.setId(id);
      return XfR.ok(receivedPaymentsNoNeedServiceImpl.updateById(receivedPaymentsNoNeed));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivedPaymentsNoNeed ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivedpaymentsnoneeds/{id}")
  public XfR patchUpdate(@RequestBody ReceivedPaymentsNoNeed receivedPaymentsNoNeed,@PathVariable Long id) {
      ReceivedPaymentsNoNeed upreceivedPaymentsNoNeed = receivedPaymentsNoNeedServiceImpl.getById(id);
      if(upreceivedPaymentsNoNeed != null){
        upreceivedPaymentsNoNeed = ObjectCopyUtils.copyProperties(receivedPaymentsNoNeed,upreceivedPaymentsNoNeed,true);
      }
      return XfR.ok(receivedPaymentsNoNeedServiceImpl.updateById(upreceivedPaymentsNoNeed));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivedpaymentsnoneeds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivedPaymentsNoNeedServiceImpl.removeById(id));
  }

  @PostMapping("/receivedpaymentsnoneeds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "received_payments_no_need");
     params.put("request", condition);

     return XfR.ok(receivedPaymentsNoNeedServiceImpl.querys(params));
  }

}
