package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ReconciliationAndInvoiceRelation;
import com.xforceplus.financialsettlement.service.IReconciliationAndInvoiceRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账单与发票关系-(废弃)前端控制器
 *
 * @author ultraman
 * @date 2024-01-18
 */
@RestController
public class ReconciliationAndInvoiceRelationController {

  @Autowired
  private IReconciliationAndInvoiceRelationService reconciliationAndInvoiceRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconciliationAndInvoiceRelation 对账单与发票关系-(废弃)
   * @return
   */
  @GetMapping("/reconciliationandinvoicerelations" )
  public XfR getReconciliationAndInvoiceRelations(XfPage page, ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation) {
    return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.page(page, Wrappers.query(reconciliationAndInvoiceRelation)));
  }

  /**
   * 通过id查询对账单与发票关系-(废弃)
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconciliationandinvoicerelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.getById(id));
  }

  /**
   * 新增对账单与发票关系-(废弃)
   * @param reconciliationAndInvoiceRelation 对账单与发票关系-(废弃)
   * @return XfR
   */
  @PostMapping("/reconciliationandinvoicerelations")
  public XfR save(@RequestBody ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation) {
     return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.save(reconciliationAndInvoiceRelation));
  }

  /**
   * 修改-传入修改后的全部数据对账单与发票关系-(废弃)
   * @param reconciliationAndInvoiceRelation 对账单与发票关系-(废弃)
   * @return XfR
   */
  @PutMapping("/reconciliationandinvoicerelations/{id}")
  public XfR putUpdate(@RequestBody ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation,@PathVariable Long id) {
      reconciliationAndInvoiceRelation.setId(id);
      return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.updateById(reconciliationAndInvoiceRelation));
  }

  /**
   * 修改-传入修改的数据对账单与发票关系-(废弃)
   * @param reconciliationAndInvoiceRelation 对账单与发票关系-(废弃)
   * @return XfR
   */
  @PatchMapping("/reconciliationandinvoicerelations/{id}")
  public XfR patchUpdate(@RequestBody ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation,@PathVariable Long id) {
      ReconciliationAndInvoiceRelation upreconciliationAndInvoiceRelation = reconciliationAndInvoiceRelationServiceImpl.getById(id);
      if(upreconciliationAndInvoiceRelation != null){
        upreconciliationAndInvoiceRelation = ObjectCopyUtils.copyProperties(reconciliationAndInvoiceRelation,upreconciliationAndInvoiceRelation,true);
      }
      return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.updateById(upreconciliationAndInvoiceRelation));
  }

  /**
   * 通过id删除对账单与发票关系-(废弃)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconciliationandinvoicerelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.removeById(id));
  }

  @PostMapping("/reconciliationandinvoicerelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconciliation_and_invoice_relation");
     params.put("request", condition);

     return XfR.ok(reconciliationAndInvoiceRelationServiceImpl.querys(params));
  }

}
