package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeMember;
import com.xforceplus.financialsettlement.service.IChargeCodeMemberService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class ChargeCodeMemberController {

  @Autowired
  private IChargeCodeMemberService chargeCodeMemberServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeMember ${table.comment}
   * @return
   */
  @GetMapping("/chargecodemembers" )
  public XfR getChargeCodeMembers(XfPage page, ChargeCodeMember chargeCodeMember) {
    return XfR.ok(chargeCodeMemberServiceImpl.page(page, Wrappers.query(chargeCodeMember)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodemembers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeMemberServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeMember ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodemembers")
  public XfR save(@RequestBody ChargeCodeMember chargeCodeMember) {
     return XfR.ok(chargeCodeMemberServiceImpl.save(chargeCodeMember));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeMember ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodemembers/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeMember chargeCodeMember,@PathVariable Long id) {
      chargeCodeMember.setId(id);
      return XfR.ok(chargeCodeMemberServiceImpl.updateById(chargeCodeMember));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeMember ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodemembers/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeMember chargeCodeMember,@PathVariable Long id) {
      ChargeCodeMember upchargeCodeMember = chargeCodeMemberServiceImpl.getById(id);
      if(upchargeCodeMember != null){
        upchargeCodeMember = ObjectCopyUtils.copyProperties(chargeCodeMember,upchargeCodeMember,true);
      }
      return XfR.ok(chargeCodeMemberServiceImpl.updateById(upchargeCodeMember));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodemembers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeMemberServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodemembers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_member");
     params.put("request", condition);

     return XfR.ok(chargeCodeMemberServiceImpl.querys(params));
  }

}
