package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.DepartmentBudget;
import com.xforceplus.financialsettlement.service.IDepartmentBudgetService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class DepartmentBudgetController {

  @Autowired
  private IDepartmentBudgetService departmentBudgetServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param departmentBudget ${table.comment}
   * @return
   */
  @GetMapping("/departmentbudgets" )
  public XfR getDepartmentBudgets(XfPage page, DepartmentBudget departmentBudget) {
    return XfR.ok(departmentBudgetServiceImpl.page(page, Wrappers.query(departmentBudget)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departmentbudgets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param departmentBudget ${table.comment}
   * @return XfR
   */
  @PostMapping("/departmentbudgets")
  public XfR save(@RequestBody DepartmentBudget departmentBudget) {
     return XfR.ok(departmentBudgetServiceImpl.save(departmentBudget));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param departmentBudget ${table.comment}
   * @return XfR
   */
  @PutMapping("/departmentbudgets/{id}")
  public XfR putUpdate(@RequestBody DepartmentBudget departmentBudget,@PathVariable Long id) {
      departmentBudget.setId(id);
      return XfR.ok(departmentBudgetServiceImpl.updateById(departmentBudget));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param departmentBudget ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departmentbudgets/{id}")
  public XfR patchUpdate(@RequestBody DepartmentBudget departmentBudget,@PathVariable Long id) {
      DepartmentBudget updepartmentBudget = departmentBudgetServiceImpl.getById(id);
      if(updepartmentBudget != null){
        updepartmentBudget = ObjectCopyUtils.copyProperties(departmentBudget,updepartmentBudget,true);
      }
      return XfR.ok(departmentBudgetServiceImpl.updateById(updepartmentBudget));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departmentbudgets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departmentBudgetServiceImpl.removeById(id));
  }

  @PostMapping("/departmentbudgets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "department_budget");
     params.put("request", condition);

     return XfR.ok(departmentBudgetServiceImpl.querys(params));
  }

}
