package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialPurchaseCheckBill;
import com.xforceplus.financialsettlement.service.IFinancialPurchaseCheckBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class FinancialPurchaseCheckBillController {

  @Autowired
  private IFinancialPurchaseCheckBillService financialPurchaseCheckBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialPurchaseCheckBill ${table.comment}
   * @return
   */
  @GetMapping("/financialpurchasecheckbills" )
  public XfR getFinancialPurchaseCheckBills(XfPage page, FinancialPurchaseCheckBill financialPurchaseCheckBill) {
    return XfR.ok(financialPurchaseCheckBillServiceImpl.page(page, Wrappers.query(financialPurchaseCheckBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialpurchasecheckbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseCheckBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialPurchaseCheckBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialpurchasecheckbills")
  public XfR save(@RequestBody FinancialPurchaseCheckBill financialPurchaseCheckBill) {
     return XfR.ok(financialPurchaseCheckBillServiceImpl.save(financialPurchaseCheckBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialPurchaseCheckBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialpurchasecheckbills/{id}")
  public XfR putUpdate(@RequestBody FinancialPurchaseCheckBill financialPurchaseCheckBill,@PathVariable Long id) {
      financialPurchaseCheckBill.setId(id);
      return XfR.ok(financialPurchaseCheckBillServiceImpl.updateById(financialPurchaseCheckBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialPurchaseCheckBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialpurchasecheckbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialPurchaseCheckBill financialPurchaseCheckBill,@PathVariable Long id) {
      FinancialPurchaseCheckBill upfinancialPurchaseCheckBill = financialPurchaseCheckBillServiceImpl.getById(id);
      if(upfinancialPurchaseCheckBill != null){
        upfinancialPurchaseCheckBill = ObjectCopyUtils.copyProperties(financialPurchaseCheckBill,upfinancialPurchaseCheckBill,true);
      }
      return XfR.ok(financialPurchaseCheckBillServiceImpl.updateById(upfinancialPurchaseCheckBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialpurchasecheckbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialPurchaseCheckBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialpurchasecheckbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_purchase_check_bill");
     params.put("request", condition);

     return XfR.ok(financialPurchaseCheckBillServiceImpl.querys(params));
  }

}
