package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.SourceMateData;
import com.xforceplus.financialsettlement.service.ISourceMateDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class SourceMateDataController {

  @Autowired
  private ISourceMateDataService sourceMateDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sourceMateData ${table.comment}
   * @return
   */
  @GetMapping("/sourcematedatas" )
  public XfR getSourceMateDatas(XfPage page, SourceMateData sourceMateData) {
    return XfR.ok(sourceMateDataServiceImpl.page(page, Wrappers.query(sourceMateData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sourcematedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sourceMateDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sourceMateData ${table.comment}
   * @return XfR
   */
  @PostMapping("/sourcematedatas")
  public XfR save(@RequestBody SourceMateData sourceMateData) {
     return XfR.ok(sourceMateDataServiceImpl.save(sourceMateData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sourceMateData ${table.comment}
   * @return XfR
   */
  @PutMapping("/sourcematedatas/{id}")
  public XfR putUpdate(@RequestBody SourceMateData sourceMateData,@PathVariable Long id) {
      sourceMateData.setId(id);
      return XfR.ok(sourceMateDataServiceImpl.updateById(sourceMateData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sourceMateData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sourcematedatas/{id}")
  public XfR patchUpdate(@RequestBody SourceMateData sourceMateData,@PathVariable Long id) {
      SourceMateData upsourceMateData = sourceMateDataServiceImpl.getById(id);
      if(upsourceMateData != null){
        upsourceMateData = ObjectCopyUtils.copyProperties(sourceMateData,upsourceMateData,true);
      }
      return XfR.ok(sourceMateDataServiceImpl.updateById(upsourceMateData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sourcematedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sourceMateDataServiceImpl.removeById(id));
  }

  @PostMapping("/sourcematedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "source_mate_data");
     params.put("request", condition);

     return XfR.ok(sourceMateDataServiceImpl.querys(params));
  }

}
