package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.financialsettlement.entity.AuthorizedMembers;
import com.xforceplus.financialsettlement.service.IAuthorizedMembersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-04
 */
@RestController
public class AuthorizedMembersController {

  @Autowired
  private IAuthorizedMembersService authorizedMembersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param authorizedMembers ${table.comment}
   * @return
   */
  @GetMapping("/authorizedmemberss" )
  public XfR getAuthorizedMemberss(XfPage page, AuthorizedMembers authorizedMembers) {
    return XfR.ok(authorizedMembersServiceImpl.page(page, Wrappers.query(authorizedMembers)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/authorizedmemberss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(authorizedMembersServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param authorizedMembers ${table.comment}
   * @return XfR
   */
  @PostMapping("/authorizedmemberss")
  public XfR save(@RequestBody AuthorizedMembers authorizedMembers) {
     return XfR.ok(authorizedMembersServiceImpl.save(authorizedMembers));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param authorizedMembers ${table.comment}
   * @return XfR
   */
  @PutMapping("/authorizedmemberss/{id}")
  public XfR putUpdate(@RequestBody AuthorizedMembers authorizedMembers,@PathVariable Long id) {
      authorizedMembers.setId(id);
      return XfR.ok(authorizedMembersServiceImpl.updateById(authorizedMembers));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param authorizedMembers ${table.comment}
   * @return XfR
   */
  @PatchMapping("/authorizedmemberss/{id}")
  public XfR patchUpdate(@RequestBody AuthorizedMembers authorizedMembers,@PathVariable Long id) {
      AuthorizedMembers upauthorizedMembers = authorizedMembersServiceImpl.getById(id);
      if(upauthorizedMembers != null){
        upauthorizedMembers = ObjectCopyUtils.copyProperties(authorizedMembers,upauthorizedMembers,true);
      }
      return XfR.ok(authorizedMembersServiceImpl.updateById(upauthorizedMembers));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/authorizedmemberss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(authorizedMembersServiceImpl.removeById(id));
  }

  @PostMapping("/authorizedmemberss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "authorized_members");
     params.put("request", condition);

     return XfR.ok(authorizedMembersServiceImpl.querys(params));
  }

}
